<?php
$this->extend('/Common/2col');
$title = !empty($data) ? $this->I18n->translate($data, 'Page.title') : __d('buzz_camps', 'Camps');
$this->assign('title', $title);
$this->start('side');
echo $this->Fa->link('chevron-circle-right', __d('buzz_camps', 'Coaches'), ['controller' => 'account_profiles', 'action' => 'index'], ['class' => 'button button--fill button--back']);
$this->end(); // side
?>
<?php if (!empty($data['Image'][0])): ?>
	<div class="text-center">
		<?php echo $this->Img->resize($data['Image'][0], ['width' => 870]); ?>
	</div>
	<div class="content__spacer"></div>
<?php endif; ?>

<?php echo !empty($data) ? $this->I18n->translate($data, 'Page.body') : null; ?>

<div class="row">
	<div class="col-xs-12">
		<div class="content__spacer"></div>

		<?php $tabs = (!empty($data['Tab']) ? count($data['Tab']) : 0); ?>

		<?php if ($tabs > 1): ?>

			<div class="responsivetabs">
				<ul>
					<?php if (!empty($camps)): ?>
						<li><?php echo $this->Html->link(__d('buzz_camps', 'Camps'), '#tab-0'); ?></li>
					<?php endif; ?>
					<?php $i = 0; ?>
					<?php foreach ($data['Tab'] as $tab): ?>
						<?php ++$i; ?>
						<li><?php echo $this->Html->link($this->I18n->translate($tab, 'title'), '#tab-' . $i); ?></li>
					<?php endforeach; ?>
				</ul>
				<?php if (!empty($camps)): ?>
					<div id="tab-0"></div>
				<?php endif; ?>
				<?php $i = 0; ?>
				<?php foreach ($data['Tab'] as $tab): ?>
					<?php ++$i; ?>
					<div id="tab-<?php echo $i; ?>"><?php echo $this->I18n->translate($tab, 'content'); ?></div>
				<?php endforeach; ?>
			</div>

		<?php else: ?>

			<?php echo $this->element('BuzzCamps.camp_packages', ['data' => $camps]); ?>

		<?php endif; ?>

	</div>
</div>
