<?php
$this->extend('BuzzCamps./Common/camps');
$this->assign('title', 'Camps');
?>

<?php $this->end(); // side ?>

<div class="row">
	<div class="col-xs-12 col-sm-9">

		<h3><?php echo __d('buzz_camps', 'Edit Profile'); ?></h3>

		<?php
			echo $this->Form->create('AccountProfile', ['type' => 'file', 'class' => 'form--side-labels validate']);
			echo $this->Form->inputs(array(
				'fieldset' => false,
				'AccountProfile.id' => array('type' => 'hidden'),
				'AccountProfile.display_name' => array('label' => __d('buzz_camps', 'Display Name')),
				'AccountProfile.description' => array('label' => __d('buzz_camps', 'Description'), 'type' => 'textarea'),
				'AccountProfile.contact_email' => array('type' => 'email', 'label' => __d('buzz_camps', 'Contact Email')),
				'AccountProfile.contact_telephone' => array('type' => 'text', 'label' => __d('buzz_camps', 'Contact Telephone')),
				'Image.0.filename' => array(
					'label' => __d('buzz_camps', 'Your Profile Picture'),
					'type' => 'file',
					'between' => '<div>' . (!empty($this->request->data['Image'][0]['filename']) ? $this->Img->resize($this->request->data['Image'][0], ['width' => 130, 'height' => 120, 'crop' => true]) : null),
					'after' => '</div>'
				),
				'Image.0.id' => array('type' => 'hidden'),
				'Image.0.model' => array('type' => 'hidden', 'value' => 'AccountProfile'),
				'Image.0.model_id' => array('type' => 'hidden'),
				'Image.0.sequence' => array('type' => 'hidden'),
				'Image.0.attachment_type' => array('type' => 'hidden', 'value' => 'Image'),
				'AccountProfile.is_active' => array('label' => __d('buzz_camps', 'Show on Coaches page'), 'div' => ['class' => 'input checkbox checkbox--custom checkbox--left'])
			));
			echo $this->Form->button(__d('buzz_camps', 'Update Details') . '<i class="fa fa-chevron-circle-right fa-inline"></i>', ['class' => 'button']);
			echo $this->Form->end();
		?>
	</div>
</div>
