<?php
$this->extend('BuzzCamps./Common/camps');
$this->assign('title', 'Camps');
?>

<?php $this->end(); // side ?>

<?php if (empty($profile)): ?>

	<?php echo $this->Fa->link('chevron-circle-right', __d('buzz_camps', 'Create Profile'), ['action' => 'account_profile'], ['class' => 'button']); ?>

<?php else: ?>

	<div class="row overview">
		<div class="col-xs-12 col-sm-8">
			<h3><?php echo __d('buzz_camps', 'Upcoming Camps') ?></h3>
		</div>
		<div class="col-xs-12 col-sm-4 xs-text-left text-right">
			<?php echo $this->Fa->link('chevron-circle-right fa-inline', __d('buzz_camps', 'View All Upcoming Camps'), ['action' => 'account_camps'], ['class' => 'overview__link', 'space' => false]); ?>
		</div>
		<div class="col-xs-12">
			<?php echo $this->element('camps_table', ['edit' => true]); ?>
		</div>
		<div class="col-xs-12">
			<?php echo $this->Fa->link('chevron-circle-right fa-inline', __d('buzz_camps', 'Add Camp'), ['action' => 'account_edit_camp'], ['class' => 'button cf', 'space' => false]); ?>
		</div>
	</div>

	<div class="row overview">
		<div class="col-xs-12 col-sm-8">
			<h3><?php echo __d('buzz_camps', 'Past Camps') ?></h3>
		</div>
		<div class="col-xs-12 col-sm-4 xs-text-left text-right">
			<?php echo $this->Fa->link('chevron-circle-right fa-inline', __d('buzz_camps', 'View All Past Camps'), ['action' => 'account_past_camps'], ['class' => 'overview__link', 'space' => false]); ?>
		</div>
		<div class="col-xs-12">
			<?php echo $this->element('camps_table', ['data' => $pastCamps, 'noLink' => true]); ?>
		</div>
	</div>

<?php endif; ?>
