<?php
$this->extend('BuzzCamps./Common/camps');
$this->assign('title', 'Camps');
?>

<?php $this->end(); // side ?>

<div class="row">
	<div class="col-xs-12 col-sm-9">

		<h3><?php echo $id === null ? __d('buzz_camps', 'Add Camp') : __d('buzz_camps', 'Edit Camp'); ?></h3>

		<?php
			$siteInput = array('label' => __d('buzz_camps', 'Location'), 'type' => 'select', 'options' => $siteList);

			if (count($siteList) == 1):
				reset($siteList);
				$siteInput = array('type' => 'hidden', 'value' => key($siteList));
			endif;

			echo $this->Form->create('Camp', ['type' => 'file', 'class' => 'form--side-labels validate']);
			echo $this->Form->inputs(array(
				'fieldset' => false,
				'Camp.id' => array('type' => 'hidden'),
				'Camp.name' => array('label' => __d('buzz_camps', 'Name')),
				'Camp.tag_line' => array('label' => __d('buzz_camps', 'Short Description')),
				'Camp.date' => array('label' => __d('buzz_camps', 'Date'), 'type' => 'text', 'class' => 'datepicker'),
				'Camp.time' => array('label' => __d('buzz_camps', 'Time'), 'type' => 'text'),
				'Camp.site_id' => $siteInput,
				'Camp.description' => array('label' => __d('buzz_camps', 'Description'), 'type' => 'textarea'),
				'Camp.slots_available' => array('label' => __d('buzz_camps', 'Slots Available')),
				'Camp.cost' => array('label' => __d('buzz_camps', 'Cost (%s)', [$this->Number->currencySymbol()])),
				'Image.0.filename' => array(
					'label' => __d('buzz_camps', 'Camp Picture'),
					'type' => 'file',
					'between' => '<div>' . (!empty($this->request->data['Image'][0]['filename']) ? $this->Img->resize($this->request->data['Image'][0], ['width' => 130, 'height' => 120, 'crop' => true]) : null),
					'after' => '</div>'
				),
				'Image.0.id' => array('type' => 'hidden'),
				'Image.0.model' => array('type' => 'hidden', 'value' => 'Camp'),
				'Image.0.model_id' => array('type' => 'hidden'),
				'Image.0.sequence' => array('type' => 'hidden'),
				'Image.0.attachment_type' => array('type' => 'hidden', 'value' => 'Image'),
				'Camp.is_bookable' => array('label' => __d('buzz_camps', 'Is Bookable'), 'div' => ['class' => 'input checkbox checkbox--custom checkbox--left']),
			));
			echo $this->Form->button(
				($id === null ? __d('buzz_camps', 'Add Camp') : __d('buzz_camps', 'Update Camp')) . '<i class="fa fa-chevron-circle-right fa-inline"></i>',
				['class' => 'button']
			);
			echo $this->Form->end();
		?>
	</div>
</div>
