<?php
$this->extend('BuzzCamps./Common/camps');
$this->assign('title', 'Camps');
?>

<?php $this->end(); // side ?>
<div class="row">
	<div class="col-xs-12 col-sm-8">
		<h3><?= h($data['Camp']['name']) ?></h3>
	</div>
	<div class="col-xs-12 col-sm-4 xs-text-left text-right">
		<?php echo $this->Fa->link('chevron-circle-left fa-inline', __d('buzz_camps', 'Back to Bookings'), ['action' => 'account_bookings', $data['Camp']['id']], ['class' => 'overview__link', 'space' => false, 'before' => true]); ?>
	</div>
	<div class="col-xs-12">
		<p>
			<?= __d('buzz_camps', 'Are you sure you want to delete %s\'s booking? You will not be able to undo this change!', [h($data['CampBooking']['full_name'])]) ?>
		</p>
		<?= $this->Form->create() ?>

		<?= $this->Form->hidden('CampBooking.id') ?>

		<?php
			echo $this->Form->button(
				__d('buzz_camps', 'Delete Booking') . '<i class="fa fa-chevron-circle-right fa-inline"></i>',
				['class' => 'button']
			);
		?>
		<?php
			echo $this->Html->link('Cancel', ['action' => 'account_bookings', $data['Camp']['id']], ['class' => 'button background--primary']);
		?>

		<?= $this->Form->end(); ?>
	</div>
</div>
