<?php
$this->extend('BuzzCamps./Common/camps');
$this->assign('title', 'Camps');
?>

<?php $this->end(); // side ?>

<div class="row">
	<div class="col-xs-12 col-sm-8">
		<h3><?php echo $data['Camp']['name']; ?></h3>
	</div>
	<div class="col-xs-12 col-sm-4 xs-text-left text-right">
		<?php echo $this->Fa->link('chevron-circle-right fa-inline', __d('buzz_camps', 'Add Booking'), ['action' => 'account_add_booking', $data['Camp']['id']], ['class' => 'overview__link', 'space' => false]); ?>
	</div>
	<div class="col-xs-12">
		<div class="overflow-auto">
			<table class="table--flat">
				<thead>
					<tr>
						<th><?php echo __d('buzz_camps', 'First Name') ?></th>
						<th><?php echo __d('buzz_camps', 'Last Name') ?></th>
						<th><?php echo __d('buzz_camps', 'Email') ?></th>
						<th><?php echo __d('buzz_camps', 'Telephone') ?></th>
						<th></th>
					</tr>
				</thead>
				<tbody>
				<?php foreach ($data['CampBooking'] as $row): ?>
					<tr>
						<td>
							<?php echo $row['first_name']; ?>
						</td>
						<td>
							<?php echo $row['last_name']; ?>
						</td>
						<td>
							<?php echo $row['email']; ?>
						</td>
						<td>
							<?php echo $row['telephone']; ?>
						</td>
						<td>
							<?= $this->Html->link(__d('buzz_camps', 'Delete'), ['action' => 'account_delete_booking', $row['id']]) ?>
						</td>
					</tr>
				<?php endforeach; ?>
				</tbody>
			</table>
		</div>
	</div>
</div>
