<?php
$this->extend('BuzzCamps./Common/camps');
$this->assign('title', 'Camps');
?>

<?php $this->end(); // side ?>
<div class="row">
	<div class="col-xs-12 col-sm-8">
		<h3><?= h($data['Camp']['name']) ?></h3>
	</div>
	<div class="col-xs-12 col-sm-4 xs-text-left text-right">
		<?php echo $this->Fa->link('chevron-circle-left fa-inline', __d('buzz_camps', 'Back to Bookings'), ['action' => 'account_bookings', $data['Camp']['id']], ['class' => 'overview__link', 'space' => false, 'before' => true]); ?>
	</div>
	<div class="col-xs-12">
		<?php
			echo $this->Form->create('CampBooking', ['class' => 'form--side-labels validate']);
			echo $this->Form->inputs([
				'fieldset' => false,
				'CampBooking.camp_id' => ['type' => 'hidden'],
				'CampBooking.first_name' => ['label' => __d('buzz_camps', 'First Name')],
				'CampBooking.last_name' => ['label' => __d('buzz_camps', 'Last Name')],
				'CampBooking.email' => ['label' => __d('buzz_camps', 'Email')],
				'CampBooking.telephone' => ['label' => __d('buzz_camps', 'Telephone')]
			]);
			echo $this->Form->button(
				__d('buzz_camps', 'Add Booking') . '<i class="fa fa-chevron-circle-right fa-inline"></i>',
				['class' => 'button']
			);
			echo $this->Form->end();
		?>
	</div>
</div>
