<?php
$this->extend('/Common/view');
$this->assign('title', __d('buzz_camps', '%s Booking', [$data['Camp']['name']]));
?>
<?php echo $this->Form->create(null); ?>

<?php echo $this->Html->para('intro', $data['Camp']['tag_line']); ?>

<?php echo $this->element('BuzzCamps.camp_booking_basket'); ?>

<div class="row">
	<div class="col-xs-12 col-md-6">

		<h3><?php echo __d('buzz_camps', 'Participant Details'); ?></h3>
		<div class="form--side-labels form--compact validate">
			<?php echo $this->Form->input('CampBooking.first_name', ['label' => __d('buzz_camps', 'First Name')]); ?>
			<?php echo $this->Form->input('CampBooking.last_name', ['label' => __d('buzz_camps', 'Last Name')]); ?>
			<?php echo $this->Form->input('CampBooking.email', ['label' => __d('buzz_camps', 'Email')]); ?>
			<?php echo $this->Form->input('CampBooking.telephone', ['label' => __d('buzz_camps', 'Telephone')]); ?>
		</div>

		<?php if (Configure::read('BuzzPurchase.onsite') === true): ?>
			<div class="content__spacer">&nbsp;</div>
			<h3><?php echo __d('buzz_camps', 'Billing Details'); ?></h3>
			<div class="form--side-labels form--compact validate">
				<?php echo $this->Element('BuzzCustomers.address_form', ['model' => 'AccountCredit.CustomerAddress']); ?>
				<?php echo $this->Form->input('AccountCredit.CustomerAddress.email', ['label' => __d('buzz_camps', 'Email')]); ?>
			</div>
		<?php endif; ?>

	</div>
	<div class="col-xs-12 col-md-6">

		<?php if (Configure::read('BuzzPurchase.onsite') !== true): ?>
			<h3><?php echo __d('buzz_camps', 'Billing Details'); ?></h3>
			<div class="form--side-labels form--compact validate">
				<?php echo $this->Element('BuzzCustomers.address_form', ['model' => 'AccountCredit.CustomerAddress']); ?>
				<?php echo $this->Form->input('AccountCredit.CustomerAddress.email', ['label' => __d('buzz_camps', 'Email')]); ?>
			</div>
		<?php endif; ?>

		<?php if (Configure::read('BuzzPurchase.onsite') === true): ?>
			<h3><?php echo __d('buzz_camps', 'Payment details'); ?></h3>
			<div class="form--side-labels form--compact validate">
				<?php echo $this->element('BuzzPurchase.Forms/payment_form'); ?>
			</div>
		<?php endif; ?>

	</div>
</div>

<div class="booking__actions">
	<div class="row">
		<div class="col-xs-6">
			<?php echo $this->Html->link(__d('buzz_camps', 'Back'), ['controller' => 'camps', 'action' => 'view', $data['Camp']['id']], ['class' => 'button button--light background--septenary left']); ?>
		</div>

		<div class="col-xs-6">
			<?php echo $this->Form->button(__d('buzz_camps', 'Book Camp') . '<i class="fa fa-credit-card fa-inline"></i>', ['class' => 'button button--dark background--senary right']); ?>
		</div>
	</div>
</div>

<?php echo $this->Form->end(); ?>
