<?php
$this->extend('/Common/2col');
$this->assign('title', __d('buzz_camps', 'Coaches'));
$this->start('side');

echo $this->Fa->link('chevron-circle-left', __d('buzz_camps', 'Back to Camps'), ['controller' => 'camps', 'action' => 'index'], ['class' => 'button button--fill button--back', 'before' => true]);

$this->end(); // side
?>

<?php if (! empty($data)): ?>

	<?php foreach ($data as $coach): ?>

		<div class="row listing">
			<div class="col-xs-12 col-sm-2_9">
				<?php
					$img = empty($coach['Image'][0]['filename']) ? 'avatar.png' : $coach['Image'][0];
					echo $this->Img->resize($img, ['width' => 468, 'height' => 356, 'crop' => true], ['class' => 'listing__image']);
				?>
			</div>
			<div class="content__spacer xs-visible"></div>
			<div class="col-xs-12 col-sm-5_9" itemscope itemtype="http://schema.org/Person">
				<h2 class="h3"><?= $coach['AccountProfile']['display_name'] ?></h2>
				<ul class="fa-ul no-bullets">
					<?php if (!empty($coach['AccountProfile']['contact_email'])): ?>
						<li><i class="fa-li fa fa-envelope"></i> <span itemprop="email"><?= $this->Text->autoLinkEmails($coach['AccountProfile']['contact_email']); ?></span></li>
					<?php endif; ?>
					<?php if (!empty($coach['AccountProfile']['contact_telephone'])): ?>
						<li><i class="fa-li fa fa-phone"></i> <span itemprop="telephone"><?= $coach['AccountProfile']['contact_telephone']; ?></span></li>
					<?php endif; ?>
				</ul>

				<div class="js-read-more">
					<?= $this->Text->autoParagraph($coach['AccountProfile']['description']); ?>
				</div>
				<?php if ($this->Time->isFuture($coach[0]['date'])): ?>
					<?php
						echo $this->Fa->link(
							'chevron-circle-right',
							__d('buzz_camps', 'View Upcoming Camps'),
							['controller' => 'camps', 'action' => 'coach', $coach['AccountProfile']['id']],
							['class' => 'button']
						);
					?>
				<?php endif ?>
			</div>
			<div class="content__spacer"></div>
		</div>

	<?php endforeach; ?>

	<div class="row pagination">
		<div class="col-xs-6 col-sm-2">
			<?php if ($this->Paginator->hasPrev()): ?>
				<?= $this->Paginator->prev(__d('buzz_camps', 'Prev')) ?>
			<?php endif; ?>
		</div>
		<div class="col-xs-12 col-sm-8 text-center hidden-xs">
			<?= $this->Paginator->numbers() ?>
		</div>
		<div class="col-xs-6 col-sm-2 text-right">
			<?php if ($this->Paginator->hasNext()): ?>
				<?= $this->Paginator->next(__d('buzz_camps', 'Next')) ?>
			<?php endif; ?>
		</div>
	</div>

<?php else: ?>

	<div class='flash flash--fail'>
	<?php
		echo $this->element(
			'_flash',
			array('message' => __d('buzz_camps', 'There are currently no coaches'))
		);
	?>
	</div>

<?php endif; ?>
