<?php

App::uses('BuzzDiaryAccountsAppModel', 'BuzzDiaryAccounts.Model');

/**
 * AccountProfile extends BuzzDiaryAccountsAppModel as it is an extension to
 * the accounts.
 */
class AccountProfile extends BuzzDiaryAccountsAppModel {

	public $imageSlots = 1;

	public $belongsTo = array(
		'Account' => array(
			'className' => 'BuzzDiaryAccounts.Account'
		)
	);

	public $hasMany = [
		'Camp' => [
			'className' => 'BuzzCamps.Camp'
		]
	];

	public $validate = array(
		'display_name' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			),
			'maxLength' => array(
				'rule' => array('maxLength', 100),
				'message' => 'No more than 100 characters'
			)
		),
		'description' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Required'
			)
		),
		'contact_email' => array(
			'email' => array(
				'rule' => 'email',
				'message' => 'Valid email addresses only',
				'allowEmpty' => true
			),
			'maxLength' => array(
				'rule' => array('maxLength', 254),
				'message' => 'No more than 254 characters'
			)
		),
		'contact_telephone' => array(
			'maxLength' => array(
				'rule' => array('maxLength', 45),
				'message' => 'No more than 45 characters',
				'allowEmpty' => true
			)
		)
	);

	public function getAccountProfile($accountId) {
		return $this->find(
			'first',
			array(
				'contain' => array(
					'Image'
				),
				'conditions' => array(
					'AccountProfile.account_id' => $accountId
				)
			)
		);
	}

}
