<?php
App::uses('CakeEventListener', 'Event');
App::uses('CustomEmail', 'Lib');
App::uses('PurchaseTrait', 'BuzzPurchase.Lib/Traits');

class CampBookingListener implements CakeEventListener {

	use PurchaseTrait;

	public function implementedEvents() {
		return array(
			'Model.CampBooking.created' => 'sendCampBookingConfirmationEmail'
		);
	}

/**
 * Send camp booking confirmation email.
 *
 * @param CakeEvent $Event
 * @return void
 */
	public function sendCampBookingConfirmationEmail(CakeEvent $Event) {
		$id = $Event->data['id'];

		$data = ClassRegistry::init('BuzzCamps.CampBooking')->readForView($id);

		// Calculate the tax.
		$taxPercent = Configure::read('BuzzPurchase.taxPercent');
		$tax = empty($taxPercent) ? 0 : $this->calculateTax($data['CampBooking']['total_paid'], $taxPercent);

		// Send payment request email
		$Email = ClassRegistry::init('BuzzEmails.Email');
		$tokens = [
			'fullName' => $data['CampBooking']['full_name'],
			'firstName' => $data['CampBooking']['first_name'],
			'lastName' => $data['CampBooking']['last_name'],
			'amount' => CakeNumber::currency($data['CampBooking']['total_paid']),
			'salesRef' => $data['CampBooking']['sales_ref'],
			'camp' => $data['Camp']['name'],
			'date' => CakeTime::i18nFormat($data['Camp']['date'], '%e %B %Y'),
			'time' => $data['Camp']['time'],
			'instructor' => $data['Camp']['AccountProfile']['display_name'],
			'tax' => CakeNumber::currency($tax)
		];
		$email = ClassRegistry::init('BuzzEmails.Email')->generateEmailData(
			'BuzzCamps.camp_booking_confirmation_email',
			$tokens
		);
		$Email->queueEmail(
			$email['Email']['subject'],
			$email['Email']['content'],
			[$data['CampBooking']['email'] => $data['CampBooking']['full_name']],
			$email['Email']['from'],
			null,
			null,
			[$data['Camp']['AccountProfile']['Account']['email'] => $data['Camp']['AccountProfile']['Account']['full_name']]
		);

		// Send confirmation email to instructor.
		$email = ClassRegistry::init('BuzzEmails.Email')->generateEmailData(
			'BuzzCamps.camp_booking_coach_confirmation_email',
			$tokens
		);
		$Email->queueEmail(
			$email['Email']['subject'],
			$email['Email']['content'],
			[$data['Camp']['AccountProfile']['Account']['email'] => $data['Camp']['AccountProfile']['Account']['full_name']],
			$email['Email']['from']
		);

		return;
	}

}
