<?php

App::uses('BuzzDiaryAccountsAppController', 'BuzzDiaryAccounts.Controller');

class AccountProfilesController extends BuzzDiaryAccountsAppController {

/**
 * List all coaches
 * @return void
 */
	public function index() {
		// We want to list all active coaches (regardless of whether or not they have any camps
		// running).
		$this->paginate = [
			'fields' => [
				'AccountProfile.*',
				'MAX(Camp.date) AS date'
			],
			'contain' => [
				'Account',
				'Image'
			],
			'joins' => [
				[
					'table' => 'camps',
					'alias' => 'Camp',
					'type' => 'LEFT',
					'conditions' => [
						'AccountProfile.id = Camp.account_profile_id',
						'Camp.is_bookable' => true,
						'Camp.date >=' => gmdate('Y-m-d')
					]
				]
			],
			'conditions' => [
				'Account.is_active' => true,
				'AccountProfile.is_active' => true
			],
			'order' => [
				'AccountProfile.display_name' => 'ASC'
			],
			'group' => [
				'AccountProfile.id'
			]
		];
		$data = $this->paginate();
		$this->Meta->canonical(['action' => 'index']);
		$this->set(compact('data'));
		$this->view = 'BuzzCamps./AccountProfiles/index';
		return;
	}

}
