<?php
class BuzzCampsAddedConfirmationEmail extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'BuzzCamps_added_confirmation_email';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
		),
		'down' => array(
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction === 'up') {
			$EmailGroup = ClassRegistry::init('BuzzEmails.EmailGroup');
			$data = array(
				'name' => 'Camps'
			);
			$EmailGroup->save($data);
			$data = array(
				'name' => 'Coach\'s Camp Booking Confirmation',
				'system_name' => 'BuzzCamps.camp_booking_coach_confirmation_email',
				'email_group_id' => $EmailGroup->id,
				'subject' => 'Camp Booking Confirmation',
				'content' => '<p>Hi {instructor},</p><p>{fullName} has reserved a place on your {camp} camp on the {date} at {time}. They made a payment of {amount} (their sales reference is: {salesRef}).</p>',
				'required_tokens' => '["instructor","camp","date"]',
				'optional_tokens' => '["fullName","firstName","lastName","salesRef","amount","time"]'
			);
			ClassRegistry::init('BuzzEmails.Email')->save($data);
		}
		return true;
	}
}
