<?php
class BuzzDiaryCampsEmails extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'BuzzDiaryCamps_emails';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
		),
		'down' => array(
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction === 'up') {
			$EmailGroup = ClassRegistry::init('BuzzEmails.EmailGroup');
			$data = array(
				'name' => 'Camps'
			);
			$EmailGroup->save($data);
			$data = array(
				'name' => 'Camp Booking Confirmation',
				'system_name' => 'BuzzCamps.camp_booking_confirmation_email',
				'email_group_id' => $EmailGroup->id,
				'subject' => 'Camp Booking Confirmation',
				'content' => '<p>Hi {firstName},</p><p>Your sales reference is: <strong>{salesRef}</strong></p><p>You\'re successfully booked on the {camp} camp on the {date} at {time}. A payment of {amount} has been received.</p>',
				'required_tokens' => '["salesRef","amount","camp","date","time"]',
				'optional_tokens' => '["fullName","firstName","lastName","instructor"]'
			);
			ClassRegistry::init('BuzzEmails.Email')->save($data);
		}
		return true;
	}
}
