<?php
	$totalRelatedActivities = count($data) - 1;
	if ($totalRelatedActivities > 3):
?>
	<div class="row">
		<div class="col-xs-12">
			<h2 class="h3"><?php echo __d('buzz_bookings', 'Check out other activities'); ?></h2>
		</div>
	</div>
	<div class="row n-items gallery" data-n-items="<?php echo $totalRelatedActivities; ?>" data-gallery-breakpoints="[1,3,6,6]" style="display:none">
		<?php foreach ($data as $activity): ?>
			<?php if ($activity['Activity']['id'] !== $activityId): ?>
				<div class="n-items__item">
					<a class="category category--border<?php
						if (!empty($activity['Activity']['theme_id'])) {
							echo " theme--".$activity['Activity']['theme_id'];
						}
					?>" href="<?php echo $this->Html->url(['plugin' => 'buzz_bookings', 'controller' => 'activities', 'action' => 'view', $activity['Activity']['id']]); ?>">
						<?php
							$img = (empty($activity['ListingImage'][0])) ? 'no-image.png' : $activity['ListingImage'][0];
							echo $this->Img->resize($img, ['width' => 360, 'height' => 250, 'crop' => true]);
						?>
						<div class="category__content js-match-heights-simple vertical-center">
							<div>
								<h3><?php echo $this->I18n->translate($activity, 'Activity.name'); ?><i class="fa fa-chevron-circle-right fa-inline"></i></h3>
							</div>
						</div>
					</a>
					<div class="content__spacer"></div>
				</div>
			<?php endif; ?>
		<?php endforeach; ?>
	</div>
<?php endif; ?>
