<div class="row">
	<div class="col-xs-12">
		<div class="outline--septenary outline--thin background--white padding-gutters-1_2 basket">

			<div class="row">
				<div class="col-xs-12">
					<h3>
						<?php if(Configure::read('BuzzSites.show_location')): ?>
							<?php echo __d('buzz_bookings', 'Your booking for %s at %s', [$this->Time->i18nFormat($data['Booking']['booking_date'], '%e %B %Y'), $this->I18n->translate($data, 'Site.name')]) ?>

						<?php else: ?>
							<?php echo __d('buzz_bookings', 'Your booking for %s', [$this->Time->i18nFormat($data['Booking']['booking_date'], '%e %B %Y')]) ?>
						<?php endif; ?>
					</h3>
					<p><?php echo __d('buzz_bookings', 'Check-in time: %s', [$data['Booking']['check_in_time']]); ?></p>
				</div>
			</div>

			<?php $participants = 0; ?>

			<?php foreach ($data['BookingItem'] as $item): ?>
				<div class="listing listing--booking">
					<div class="row">
						<div class="col-xs-12 col-sm-5 xs-extra-gutters-1 sm-plus-extra-gutters-2--left">
							<h3>
								<?php if (! empty($item['BookingItemVoucher'])): ?>
									<?php echo $item['BookingItemVoucher']['name']; ?>
								<?php else: ?>
									<?php echo $this->I18n->translate($item, 'ActivityPackage.name'); ?>
								<?php endif; ?>
							</h3>
							<?php if (! empty($data['Site']) && Configure::read('BuzzSites.show_location')): ?>
								<strong><?php echo __d('buzz_bookings', 'Location:'); ?></strong>
								<span><?php echo $this->I18n->translate($data, 'Site.name'); ?></span>
							<?php endif; ?>
						</div>
						<div class="col-xs-12 xs-extra-gutters-1 col-sm-2">
							<strong><?php echo __d('buzz_bookings', 'Time:'); ?></strong>
							<span class="h3"><?php echo date('H:i', strtotime($item['BookingItemPlace'][0]['date_time'])); ?></span>
						</div>
						<div class="col-xs-12 xs-extra-gutters-1 col-sm-1 xs-text-left text-right fa--senary">
							<?php if (! empty($item['participants'])): ?>
								<?php if ($item['participants'] < 5): ?>
									<?php for ($i = 0; $i < $item['participants']; $i++): ?>
										<i class="fa fa-user"></i>
									<?php endfor; ?>
								<?php else: ?>
									<i class="fa fa-users"></i>
								<?php endif; ?>
								<strong><?php echo $item['participants']; ?></strong>
							<?php elseif (! empty($item['ActivityPackage']['max_participants'])): ?>
								<?php $footnote = true; ?>
								<i class="fa fa-users"></i>
								<strong><?php echo $item['ActivityPackage']['max_participants']; ?> <sup>*</sup></strong>
							<?php endif; ?>
						</div>
						<div class="col-xs-12 xs-extra-gutters-1 col-sm-2 gutterless sm-plus-text-center">
							<strong><?php echo __d('buzz_bookings', 'Quantity:') . ' ' . $item['quantity']; ?></strong>
						</div>
						<div class="col-xs-12 xs-extra-gutters-1 col-sm-2">
							<?php if (! empty($item['BookingItemVoucher'])): ?>
								<span class="color--senary"><strong><?php echo __d('buzz_bookings', 'Redeeming Voucher'); ?></strong></span>
							<?php elseif (! empty($item['total'])): ?>
								<strong><?php echo __d('buzz_bookings', 'Price:'); ?></strong>
								<span class="large"><?php echo $this->Number->currency($item['total']); ?></span>
							<?php endif; ?>
						</div>
					</div>
				</div>
				<?php $participants += $item['participants'] * $item['quantity']; ?>
			<?php endforeach; ?>

			<?php foreach ($data['BookingExtra'] as $item): ?>
				<div class="listing listing--booking">
					<div class="row">
						<div class="col-xs-12 col-sm-5 xs-extra-gutters-1 sm-plus-extra-gutters-2--left">
							<h3><?php echo $this->I18n->translate($item, 'Extra.name'); ?></h3>
						</div>
						<div class="col-xs-12 xs-extra-gutters-1 col-sm-3">
							<!-- time -->
						</div>
						<div class="col-xs-12 xs-extra-gutters-1 col-sm-2 gutterless sm-plus-text-center">
							<strong><?php echo __d('buzz_bookings', 'Quantity:') . ' ' . $item['quantity']; ?></strong>
						</div>
						<div class="col-xs-12 xs-extra-gutters-1 col-sm-2">
							<?php if (!empty($item['total'])): ?>
								<strong><?php echo __d('buzz_bookings', 'Price:'); ?></strong>
								<span class="large"><?php echo $this->Number->currency($item['total']); ?></span>
							<?php endif; ?>
						</div>
					</div>
				</div>
			<?php endforeach; ?>

			<?php if ($data['Booking']['is_insured']): ?>
				<div class="listing listing--booking">
					<div class="row">
						<div class="col-xs-12 col-sm-8 xs-extra-gutters-1 sm-plus-extra-gutters-2--left">
							<h3><?php echo __d('buzz_bookings', '\'Any Reason\' Protection'); ?></h3>
						</div>
						<div class="col-xs-12 xs-extra-gutters-1 col-sm-2 gutterless sm-plus-text-center">
							<strong><?php echo __d('buzz_bookings', 'Quantity:'); ?> 1</strong>
						</div>
						<div class="col-xs-12 xs-extra-gutters-1 col-sm-2">
							<strong><?php echo __d('buzz_bookings', 'Price:'); ?></strong>
							<span class="large"><?php echo $this->Number->currency($data['Booking']['insurance_cost']); ?></span>
						</div>
					</div>
				</div>
			<?php endif; ?>

			<?php if (!empty($footnote)): ?>
				<p><small>* <?php echo __d('buzz_bookings', 'Maximum number of participants'); ?></small></p>
			<?php endif; ?>

			<?php if (! empty($data['Booking']['discount']) && ! empty($data['Booking']['discount_code'])): ?>
				<div class="row">
					<div class="col-xs-12 col-sm-3 basket__total pull-right text-right">
						<strong><?php echo __d('buzz_bookings', 'Sub-Total:'); ?> <span class="large"><?php echo $this->Number->currency(($data['Booking']['discount'] + $data['Booking']['total_cost'])); ?></strong>
					</div>
				</div>
				<div class="row">
					<div class="col-xs-12 col-sm-3 basket__total pull-right text-right">
						<strong><?php echo __d('buzz_bookings', 'Discount:'); ?> <span class="large"><?php echo $this->Number->currency($data['Booking']['discount']); ?></strong>
					</div>
				</div>
			<?php endif; ?>

			<?php
				// Temporary hack to put VAT on Bodyflight baskets until a proper VAT solution is
				// built. This will want removing once we can properly handle VAT across the sites.
			?>
			<?php if (! empty($paid) && Configure::check('BuzzPurchase.taxPercent')): ?>
				<div class="row">
					<div class="col-xs-12 basket__total text-right">
						<strong>
							<?= (Configure::check('BuzzPurchase.taxLabel') ? Configure::read('BuzzPurchase.taxLabel') : __('VAT')) ?> <span>
								<?php
									if (Configure::read('BuzzPurchase.showAmount') && Configure::check('BuzzPurchase.showPercent')) {
										echo "(" . Configure::read('BuzzPurchase.taxPercent') . "%) " . $this->Purchase->tax($data['Booking']['total_cost']);
									} elseif (Configure::read('BuzzPurchase.showAmount')) {
										echo $this->Purchase->tax($data['Booking']['total_cost']);
									} elseif (Configure::check('BuzzPurchase.showPercent')) {
										echo Configure::read('BuzzPurchase.taxPercent') . "%";
									}
								?>
							</span>
						</strong>
					</div>
				</div>
			<?php endif; ?>

			<div class="row">
				<div class="col-xs-12 col-sm-9">
					<div class="content__spacer--small">&nbsp;</div>
					<?php if (empty($paid)): ?>
						<p>
							<?php echo __d('buzz_bookings', 'Time remaining to complete this booking:'); ?>
							<span class="js-countdown color--warning" data-countdown-seconds="<?php echo $timeRemaining; ?>" data-countdown-load-url="<?php echo $this->Html->url($timeoutRedirect); ?>"></span>
						</p>
					<?php endif; ?>
				</div>


				<div class="col-xs-12 col-sm-3 basket__total text-right">
					<strong><?php echo !empty($paid) ? __d('buzz_bookings', 'Total Paid:') : __d('buzz_bookings', 'Total:'); ?> <span class="large"><?php echo $this->Number->currency($data['Booking']['total_cost']); ?></strong>
				</div>
			</div>
			<?php
			if (! empty($showWaviersForm)):
				echo $this->element('BuzzWaivers.Booking/booking_waiver_step1', ['data' => $data, 'participants' => $participants]);
			endif;
			?>
		</div>

		<div class="content__spacer"></div>
	</div>
</div>

<?php if (! empty($showDiscountForm)): ?>
	<?= $this->element('BuzzBookings.Forms/discount') ?>
<?php endif; ?>
