
<?php if (! empty($this->request->data['Booking']['discount_code'])): ?>

<div class="flash flash--info">
	The discount code <strong><?=$this->request->data['Booking']['discount_code']?></strong> has been applied to this order, discounting the total by <?=$this->Number->currency($this->request->data['Booking']['discount'])?>.
</div>

<?php endif; ?>
<div class="gw field">

	<div class="g one-half">
		<?php
			echo $this->Html->tag('h3', __d('buzz_bookings', 'Customer Address'));
			echo $this->Address->format(
				$this->request->data['CustomerAddress'],
				[
					'address_line_1',
					'address_line_2',
					'address_line_3',
					'city',
					'postcode',
					'Country.name'
				]
			);
		?>
	</div>
</div>



<div class="gw field">

	<div class="g">
		<table class='data-table'>
			<thead>
				<tr>
					<th><?php echo __d('buzz_bookings', 'Package'); ?></th>
					<th><?php echo __d('buzz_bookings', 'Upsell'); ?></th>
					<th><?php echo __d('buzz_bookings', 'Date'); ?></th>
					<th><?php echo __d('buzz_bookings', 'Time'); ?></th>
					<th><?php echo __d('buzz_bookings', 'Participants'); ?></th>
					<th><?php echo __d('buzz_bookings', 'Quantity'); ?></th>
					<th><?php echo __d('buzz_bookings', 'Total'); ?></th>
				</tr>
			</thead>
			<tbody>
				<?php foreach ($this->request->data['BookingItem'] as $item): ?>
					<tr style="border-top: 1px solid rgba(0,0,0,0.1)">
						<td>
							<?php if (!empty($item['BookingItemVoucher'])): ?>
								<?php echo $item['BookingItemVoucher']['name']; ?><br />
								<small>Voucher: <?= $item['BookingItemVoucher']['voucher_code'] ?> (expiry date <?= $item['BookingItemVoucher']['expiry_date'] ?>)</small>
							<?php else: ?>
								<?php echo $item['ActivityPackage']['name']; ?>
							<?php endif; ?>

							<?php if (! empty($booking['Site']['name'])): ?>
								<br><small><strong>Location:</strong> <?=$this->I18n->translate($booking, 'Site.name')?></small>
							<?php endif; ?>
						</td>
						<td class="center">
							<?php if (!empty($item['is_upsell'])): ?>
								<i class="fa fa-check"></i>
							<?php endif; ?>
						</td>
						<td>
							<?php echo date('d/m/y', strtotime($item['BookingItemPlace'][0]['date_time'])); ?>
						</td>
						<td>
							<?php echo date('H:i', strtotime($item['BookingItemPlace'][0]['date_time'])); ?>
						</td>
						<td>
							<?php echo $item['participants'] ?: __d('buzz_bookings', 'Group / Party Booking'); ?>
						</td>
						<td>
							<?php echo $item['quantity']; ?>
						</td>
						<td>
							<?php echo $this->Number->currency($item['total']); ?>
						</td>
					</tr>
				<?php endforeach; ?>
				<?php if ($this->request->data['Booking']['is_insured']): ?>
					<tr>
						<td colspan="5" style="text-align:left">
							<?php echo __d('buzz_bookings', '\'Any Reason\' Protection'); ?>
						</td>
						<td>
							1
						</td>
						<td>
							<?php echo $this->request->data['Booking']['insurance_cost']; ?>
						</td>
					</tr>
				<?php endif; ?>
			</tbody>
			<tfoot>
				<?php if (! empty($this->request->data['Booking']['discount_code'])): ?>
					<tr>
						<th colspan="6" class="text--right"><?php echo __d('buzz_bookings', 'Sub-Total'); ?></th>
						<th><?php echo $this->Number->currency($this->request->data['Booking']['total_cost'] + $this->request->data['Booking']['discount']); ?></th>
					</tr>

					<tr>
						<th colspan="6" class="text--right"><?php echo __d('buzz_bookings', 'Discount'); ?></th>
						<th><?php echo $this->Number->currency($this->request->data['Booking']['discount']); ?></th>
					</tr>
				<?php endif; ?>

				<tr>
					<th colspan="6" class="text--right"><?php echo __d('buzz_bookings', 'Total Cost'); ?></th>
					<th><?php echo $this->Number->currency($this->request->data['Booking']['total_cost']); ?></th>
				</tr>
			</tfoot>
		</table>
	</div>

</div>
