<?php // This is loaded inside .modal-content of #genericModal in default.ctp ?>

<div class="modal-header">
	<span class="modal__button modal__close" data-dismiss="modal" aria-label="Close"><?php echo __d('buzz_bookings', 'Close'); ?><i class="fa fa-times fa-inline"></i></span>
	<h2><?php echo __d('buzz_bookings', 'Not ready to check out?'); ?></h2>
</div>

<div class="modal-body">

	<p><?php echo __d('buzz_bookings', 'If you\'re not quite ready to check out we can email your booking details to you.'); ?></p>

	<?php echo $this->Form->create(null, ['class' => 'form--single-input validate']); ?>

	<?php echo $this->Form->input('Booking.email', ['data-value-replace' => 'Enter your email address', 'div' => 'input input--hide-label', 'label' => __d('buzz_bookings', 'Email')]); ?>
	<?php echo $this->Form->button(__d('buzz_bookings', 'Send'), ['class' => 'button']); ?>

	<?php echo $this->Form->end(); ?>

	<p>
		<?php echo __d('buzz_bookings', 'To guarantee your booking you must complete the checkout.'); ?>
		<br />
		<?php echo __d('buzz_bookings', 'Time remaining to complete this booking:'); ?>
		<span class="js-countdown color--warning" data-countdown-seconds="<?php echo $timeRemaining; ?>" data-countdown-load-url="<?php echo $this->Html->url($timeoutRedirect); ?>"></span>
	</p>

	<div class="text-center">
		<?php echo $this->Html->link(__d('buzz_bookings', 'Actually, I am ready to check out'), ['action' => 'checkout'], ['class' => 'button button--large background--octonary']); ?>
	</div>

</div>
