<?php
$this->extend('/Common/view');
$this->assign('title', __d('buzz_bookings', 'Please select a location'));
echo $this->Html->script(['BuzzBookings.buzz_bookings.min'], ['inline' => false]);

$siteCount = count($sites);
$colClass = 'col-xs-12 col-sm-3'; // supports 4 items per row
$firstColClass = null;

if ($siteCount == 3):
	$colClass = 'col-xs-12 col-sm-4';
elseif($siteCount == 2):
	$colClass = 'col-xs-12 col-sm-3';
	$firstColClass = $colClass . ' col-sm-offset-3';
endif;
?>

<?php echo $this->Form->create(null, ['type' => 'GET']); ?>
<div class="row">
	<?php
	$i = 0;
	foreach ($sites as $site):
		$class = ($i == 0 && ! empty($firstColClass) ? $firstColClass : $colClass);
		$path = $this->Img->path(
			$site['LogoImage'][0],
			['width' => 500, 'height' => 400]
		);
		?>
		<div class="<?=$class?> text-center">
			<input type="radio" name="siteId" id="siteId<?= $site['Site']['id'] ?>"
				   value="<?= $site['Site']['id'] ?>" class="location-radio">

			<label for="siteId<?= $site['Site']['id'] ?>"
				   class="location-label category category--fixed match-heights--child"
				   style="background-image: url('<?= $path ?>'">
				<div class="category__content">
					<h3><?php echo $this->I18n->translate($site, 'Site.name'); ?></h3>
				</div>
			</label>
		</div>
		<?php $i++; ?>
	<?php endforeach; ?>
</div>
<?php echo $this->Form->end(); ?>
