<?php
$this->extend('/Common/view');
$this->assign(
	'title',
	__d(
		'buzz_bookings',
		'%s Booking Step %d',
		[
			$basket['Booking']['is_private_hire'] ? __d('buzz_bookings', 'Group / Party') : $this->I18n->translate($basket, 'Activity.name'),
			2
		]
	)
);
echo $this->Html->script(['BuzzBookings.buzz_bookings.min'], ['inline' => false]);
?>

<?php echo $this->element('BuzzBookings.bookings_basket', ['data' => $basket]); ?>

<?php echo $this->Form->create(); ?>

<div class="row">
	<div class="col-xs-12 col-sm-5 col-md-6">
		<h2 class="h3">
			<?php if(Configure::read('BuzzSites.show_location')): ?>
				<?php echo __d('buzz_bookings', 'Select a date and time for your experience at %s', $this->I18n->translate($basket, 'Site.name')); ?>
			<?php else: ?>
				<?php echo __d('buzz_bookings', 'Select a date and time for your experience'); ?>
			<?php endif; ?>
		</h2>
	</div>

	<div class="col-xs-12 col-sm-7 col-md-6 sm-plus-text-right">
		<div class="booking_key">
			<h3><?php echo __d('buzz_bookings', 'Key:'); ?></h3>
			<br class="xs-visible" />

			<?php echo $this->Html->image('booking_key-1.png'); ?>
			<?php echo __d('buzz_bookings', 'Available date(s)'); ?>
			<br class="xs-visible" />

			<?php echo $this->Html->image('booking_key-2.png'); ?>
			<?php echo __d('buzz_bookings', 'Unvailable date(s)'); ?>
			<br class="xs-visible" />

			<?php echo $this->Html->image('booking_key-3.png'); ?>
			<?php echo __d('buzz_bookings', 'Selected date'); ?>
			<br class="xs-visible" />
		</div>
	</div>
</div>

<div class="ajax-loader js-bookings-availability" data-src="<?php echo $this->Html->url(['action' => 'dates', 'ajax' => true, $basket['Site']['api_site_id']]) ?>">

</div>

<div class="booking__actions">
	<div class="row">
		<div class="col-xs-6">
			<?php echo $this->Html->link(__d('buzz_bookings', 'Back'), $previousStep, ['class' => 'button button--light background--septenary left']); ?>
		</div>

		<div class="col-xs-6">
			<?php echo $this->Form->button(__d('buzz_bookings', 'Proceed'), ['class' => 'button button--dark background--senary right button--booking-proceed', 'disabled' => 'disabled']); ?>
		</div>
	</div>
</div>

<?php echo $this->Form->end(); ?>
