<?php
$this->extend('/Common/view');
$this->assign(
	'title',
	__d(
		'buzz_bookings',
		'%s Booking Step %d',
		[
			$basket['Booking']['is_private_hire'] ? __d('buzz_bookings', 'Group / Party') : $this->I18n->translate($basket, 'Activity.name'),
			$step
		]
	)
);
echo $this->Html->script(['BuzzBookings.buzz_bookings.min'], ['inline' => false]);
?>

<?php echo $this->Form->create(); ?>
	<div class="content__spacer"></div>
	<?php echo $this->element('BuzzBookings.bookings_basket_full', ['data' => $basket]); ?>
	<?php echo $this->Form->input('Booking.id'); ?>

	<div class="booking__actions">
		<div class="row text-center">
			<div class="col-xs-12 col-sm-6 col-sm-push-3 col-md-4 col-md-push-4">
				<?php
				if (! empty($nextStep)):
					echo $this->Html->link(__d('buzz_bookings', 'I am ready to check out'), $nextStep, array(
						'class' => 'button booking__checkout button--booking-proceed'
					));
				else:
					echo $this->Form->button(__d('buzz_bookings', 'I am ready to check out'), ['class' => 'button booking__checkout button--booking-proceed']);
				endif;
				?>

				<div class="content__spacer"></div>

				<?php
					echo $this->Html->link(
						__d('buzz_bookings', 'Email me a summary instead, I\'ll check out later'),
						['action' => 'quit'],
						['data-toggle' => 'modal', 'data-target' => '#genericModal']
					);
				?>


				<div class="content__spacer">&nbsp;</div>
			</div>
		</div>

		<div class="row">
			<div class="col-xs-6">
				<?php echo $this->Html->link(__d('buzz_bookings', 'Go Back'), $previousStep, ['class' => 'button button--light left']); ?>
			</div>
		</div>
	</div>

<?php echo $this->Form->end(); ?>
