<div class="buzz-bookings-voucher js-voucher">
	<div class="row">

		<div class="col-xs-10 col-lg-3 field">
			<h3 class="field__label"><?= __d('buzz_bookings', 'Provider') ?></h3>
			<div class="field__text"><?= h($voucher['voucher_provider']) ?></div>
		</div>
		<div class="col-xs-2 lg-hidden text-center">
			<?php
				$removeUrl = [
					'action' => 'remove_voucher',
					$voucher['booking_item_id'],
					'ajax' => true
				];
				$removeClass = 'basket__delete js-bookings-remove-voucher';
				if (!empty($isMultiExperience) || !empty($isPrivateHire)) {
					$removeUrl = [
						'action' => 'remove_vouchers',
						$activityId < 0 ? 1 : 0,
						'ajax' => false
					];
					$removeClass = 'basket__delete';
				}
				echo $this->Fa->link(
					'times-circle',
					null,
					$removeUrl,
					[
						'class' => $removeClass,
						'title' => __d('buzz_bookings', 'Remove')
					]
				);
			?>
		</div>
		<div class="content__spacer content__spacer--small lg-hidden"></div>
		<div class="col-xs-6 col-lg-3">
			<h3 class="field__label"><?= $voucher['voucher_provider'] !== 'LIVE IT' ? __d('buzz_bookings', 'Voucher Number') : __d('buzz_bookings', 'Box Number') ?></h3>
			<div class="field__text"><?= h($voucher['voucher_code']) ?></div>
		</div>
		<div class="col-xs-6 col-lg-5">
			<h3 class="field__label"><?= __d('buzz_bookings', 'Product') ?></h3>
			<div class="field__text"><?= h($voucher['name']) ?></div>
		</div>
		<div class="xs-hidden sm-hidden md-hidden col-lg-1 text-center">
			<?= $this->Fa->link(
				'times-circle',
				null,
				$removeUrl,
				[
					'class' => $removeClass,
					'title' => __d('buzz_bookings', 'Remove')
				]
			) ?>
		</div>
		<div class="content__spacer content__spacer--small"></div>
		<?php if (! empty($voucher['expiry_date'])): ?>
			<div class="col-xs-6 col-lg-6">
				<h3 class="field__label"><?= __d('buzz_bookings', 'Expiry Date') ?></h3>
				<div class="field__text"><?= $this->Time->i18nFormat($voucher['expiry_date'], '%d/%m/%Y') ?></div>
			</div>
		<?php endif; ?>
		<?php if (! empty($voucher['pin_code'])): ?>
			<div class="col-xs-6 col-lg-6">
				<h3><?= $voucher['voucher_provider'] !== 'LIVE IT' ? __d('buzz_bookings', 'Pin Code') : __d('buzz_bookings', 'Security') ?></h3>
				<div class="field__text"><?= h($voucher['pin_code']) ?></div>
			</div>
		<?php endif; ?>
		<div class="content__spacer content__spacer--small"></div>

	</div>
</div>

<?php if (empty($hideButton)): ?>
	<div class="row">
		<div class="col-xs-6 col-lg-3">
			<?php
				echo $this->Form->button(
					__d('buzz_bookings', 'I have another voucher') . ' <i class="fa fa-chevron-circle-right"></i>',
					[
						'class' => 'button button--fill button--dark background--senary js-bookings-add-voucher',
						'data-url' => $this->Html->url(['action' => 'voucher', $activityId, 'ajax' => true])
					]
				);
			?>
		</div>
	</div>
<?php endif; ?>


<?php if (!empty($isMultiExperience) || !empty($isPrivateHire)): ?>

	<?php
		echo $this->Form->create(
			null,
			[
				'id' => false,
				'url' => ['action' => empty($isPrivateHire) ? 'packages' : 'private_hire', $activityId, 'ajax' => false]
			]
		);
	?>

	<?= $this->Form->hidden('Form.process', ['value' => 'vouchers']) ?>

	<div class="booking__actions">
		<div class="row">
			<div class="col-xs-6">
				<?= $this->Html->link(__d('buzz_bookings', 'I don\'t want to use a voucher'), ['action' => 'remove_vouchers', $activityId < 0 ? 1 : 0, 'ajax' => false], ['class' => 'button button--light background--septenary left']) ?>
			</div>

			<div class="col-xs-6">
				<?= $this->Form->button(__d('buzz_bookings', 'Proceed'), ['class' => 'button button--dark background--senary right']) ?>
			</div>
		</div>
	</div>

	<?= $this->Form->end() ?>

<?php endif; ?>
