<?php echo $this->Form->create(null, ['id' => false, 'url' => ['action' => 'voucher', $activityId, 'ajax' => true], 'class' => 'js-bookings-add-voucher-form buzz-bookings-voucher']); ?>

<div class="row">

	<div class="col-xs-12 col-lg-4">
		<?php
			echo $this->Voucher->providers(
				'BookingItemVoucher.voucher_provider_id',
				$voucherProviders,
				[
					'div' => 'input select js-bookings-voucher-provider',
					'empty' => __d('buzz_bookings', 'Please Select'),
				]
			);
		?>
	</div>
	<div class="col-xs-12 col-lg-3 js-bookings-voucher-code" data-liveit-label="<?= __d('buzz_bookings', 'Box Number') ?>">
		<?php
			echo $this->Form->input(
				'BookingItemVoucher.voucher_code',
				[
					'label' => __d('buzz_bookings', 'Voucher Number'),
					'div' => 'input select',
					'errorMessage' => false,
				]
			);
		?>
	</div>
	<div class="col-xs-12 col-lg-5 js-bookings-select-voucher hidden">
		<?= $this->Form->label('BookingItemVoucher.api_voucher_id', __d('buzz_bookings', 'Choose Product')) ?>
		<div class="input select"></div>
	</div>
</div>
<div class="row">
	<div class="col-xs-6 col-lg-4 js-bookings-voucher-expiry-date hidden">
		<?php
			echo $this->Form->input(
				'BookingItemVoucher.expiry_date',
				[
					'label' => __d('buzz_bookings', 'Expiry Date'),
					'div' => 'input select input--datepicker',
					'type' => 'text',
					'placeholder' => 'YYYY-MM-DD',
					'errorMessage' => false,
				]
			);
		?>
	</div>
	<div class="col-xs-6 col-lg-3 js-bookings-voucher-pin-code hidden" data-liveit-label="<?= __d('buzz_bookings', 'Security') ?>">
		<?= $this->Form->input('BookingItemVoucher.pin_code', [
			'label' => __d('buzz_bookings', 'Pin Code'),
		]) ?>
	</div>
</div>
<div class="row">
	<div class="col-xs-6 col-lg-4">
		<?php
			echo $this->Form->button(
				__d('buzz_bookings', 'Check voucher') . ' <i class="fa fa-chevron-circle-right"></i>',
				[
					'class' => 'button button--fill button--dark background--senary js-bookings-check-voucher'
				]
			);
		?>
	</div>
</div>

<?php if (!empty($isMultiExperience) || !empty($isPrivateHire) || Configure::read('BuzzBookings.disable_buy_extra_places')): ?>

	<div class="booking__actions booking__actions--cancel-voucher">
		<div class="row">
			<div class="col-xs-6">
				<?php
					if ($activityId > 0): // This is a multi-experience booking.
						$url = ['action' => 'packages', $activityId, 'ajax' => false];
					else:
						$url = ['action' => 'private_hire', 'ajax' => false];
					endif;
				?>
				<?php echo $this->Html->link(__d('buzz_bookings', 'I don\'t want to use a voucher'), $url, ['class' => 'button button--light background--septenary left']); ?>
			</div>
		</div>
	</div>

<?php endif; ?>

<?php echo $this->Form->end(); ?>
