<?php

trait TimerTrait {

	/**
	 * Timeout method for generating a flash message before redirecting to the
	 * date step.
	 *
	 * @return void Redirect to the date step
	 */
	public function timeout() {
		$this->Session->setFlash(
			__d('buzz_bookings', 'Your session has timed out'),
			'flash_fail'
		);
		$redirect = !empty($this->timeoutRedirect) ? $this->timeoutRedirect : ['action' => 'date'];
		return $this->redirect($redirect);
	}

	/**
	 * Start the booking timer.
	 *
	 * @return void
	 */
	protected function _startTimer() {
		$allowedBookingTime = Configure::read('BuzzBookings.allowed_booking_time');

		$now = time();
		$data = [
			'start_time' => $now,
			'end_time' => $now + $allowedBookingTime
		];
		$this->Session->write('BuzzBookings.timer', $data);

		return;
	}

	/**
	 * Checks the time remaining for the booking.
	 *
	 * @return int Seconds remaining
	 */
	protected function _checkTimeRemaining() {
		$now = time();
		$data = $this->Session->read('BuzzBookings.timer');

		$timeRemaining = 0;
		if (!empty($data)) {
			$timeRemaining = $data['end_time'] - $now;
		}

		$timeoutRedirect = ['action' => 'timeout'];

		if ($timeRemaining <= 0) {
			return $this->timeout();
		} else {
			$this->set(compact('timeoutRedirect', 'timeRemaining'));
		}

		return $timeRemaining;
	}

}
