<?php

$config = array(
	'BuzzBookings' => array(
		// Define the acitivity page ID for content
		'activities_page_id' => null,
		// Confirmation page ID for content
		'confirmation_page_id' => null,
		// Define the activity ID for multi-experiences
		'multi_experience' => null,
		// Define the api reference for multi-experiences
		'multi_experience_api_ref' => null,
		// Define the API's voucher provider ID (e.g. Twinwoods voucher
		// provider ID) and any alternative voucher provider names (e.g.
		// for Twinwoods: 'Bodyflight').
		'voucher_provider_id' => 8,
		'alternative_voucher_provider_names' => [],
		// Define routable routes
		'routes' => array(
			'activities' => array(
				'alias' => ':controller/:name',
				'actual' => ':plugin/:controller/:action/:id'
			)
		),
		// Define the time allowed to complete a booking (in seconds).
		'allowed_booking_time' => 1200,
		// Set if bookings are insurable.
		'insurable' => false,
		// Define the default voucher value if none is returned by the API.
		'default_voucher_value' => 0,
		// Define how many months of bookable dates should be displayed.
		'diary_months' => 3,
		// Set if activities have slider_text
		'slider_text' => false,
		// when set to true, the text at the top of booking step 1 will show. (Select the quantity of X for you, your family and friends)
		'show_step_1_intro' => true,
		// Set to true to display a checkbox for flagging activities to be shown on a Prices page.
		'prices_page' => false,
		// Toggle for showing newsletter opt-in on checkout; when set to `true` it adds a checkbox
		// and interacts with BuzzSubscribe.
		'show_newsletter_opt_in' => false,
		// Set to true to disable the 'Buy Extra Places' button on the voucher redemption form and
		// replaces it with a cancel button. Used by VREX.
		'disable_buy_extra_places' => false,
	)
);
