<?php
class FixBookingNotificationEmailGroup extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'Fix_booking_notification_email_group';

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		if ($direction === 'down') {
			return true;
		}

		$Email = ClassRegistry::init('BuzzEmails.Email');

		$group = $Email->EmailGroup->findByName('Bookings');
		if (empty($group)) {
			return false;
		}

		$notificationEmail = $Email->findBySystemName('BuzzBookings.notification_email');
		if (empty($notificationEmail)) {
			return false;
		}

		$notificationEmail['Email']['email_group_id'] = $group['EmailGroup']['id'];

		return $Email->save($notificationEmail);
	}
}
