<?php
class AddedNewDiscountDetailsFieldsToBookingItems extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'added_new_discount_details_fields_to_booking_items';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'booking_items' => array(
					'sales_ref' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'latin1_swedish_ci', 'charset' => 'latin1', 'after' => 'booking_id'),
					'discount' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '10,2', 'unsigned' => false, 'after' => 'item_unit_cost'),
					'discount_code' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'latin1_swedish_ci', 'charset' => 'latin1', 'after' => 'discount'),
					'discount_type' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 50, 'collate' => 'latin1_swedish_ci', 'charset' => 'latin1', 'after' => 'discount_code'),
				),
			),
		),
		'down' => array(
			'drop_field' => array(
				'booking_items' => array('sales_ref', 'discount', 'discount_code', 'discount_type'),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
