<?php
class BuzzBookingsSameDayBookings extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'BuzzBookings_updated_tables';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
		),
		'down' => array(
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction === 'up') {
			$data = array(
				'name' => 'Same Day Booking',
				'system_name' => 'BuzzBookings.same_day_booking',
				'subject' => 'New booking for {time} (ref: {salesRef})',
				'content' => '<p>Hi,</p><p>{fullName} has made a booking for {time} today ({date}).</p>
				<p>Their sales reference number is: {salesRef}</p>',
				'required_tokens' => '["time"]',
				'optional_tokens' => '["date","salesRef","fullName","firstName","lastName"]'
			);
			ClassRegistry::init('BuzzEmails.Email')->save($data);
		}
		return true;
	}
}
