<?php

App::uses('AppHelper', 'View/Helper');

class VoucherHelper extends AppHelper {

	public $helpers = ['Form', 'Html'];

	/**
	 * Generates the markup for the voucher providers select.
	 *
	 * @param string $fieldName Name of input field
	 * @param array $options Array of providers
	 * @param array $attributes
	 * @return string
	 */
	public function providers($fieldName, $options, $attributes = []) {
		$out = $this->Form->label($fieldName);

		if (!empty($attributes['empty'])) {
			$selectOptions[] = $this->Html->tag('option', $attributes['empty'], ['value' => '']);
		}

		foreach ($options as $val => $option) {
			if (is_array($option)) {
				foreach ($option as $value) {
					$selectOptions[] = $this->Html->tag('option', $value, ['value' => $val]);
				}
			} else {
				$selectOptions[] = $this->Html->tag('option', $option, ['value' => $val]);
			}
		}

		$name = 'data[' . implode('][', explode('.', $fieldName)) . ']';

		$out .= $this->Html->tag(
			'select',
			implode('', $selectOptions),
			[
				'name' => $name,
				'id' => Inflector::camelize(str_replace('.', '_', $fieldName))
			]
		);

		$divAttributes = [];
		if (!empty($attributes['div'])) {
			if (is_array($attributes['div'])) {
				$divAttributes = $attributes['div'];
			} else {
				$divAttributes = ['class' => $attributes['div']];
			}
		}

		return $this->Html->tag('div', $out, $divAttributes);
	}

}
