<?php foreach ($data['ActivityPackage'] as $package): ?>
	<?php
		if ($package['participants'] > 0):
			$url = ['controller' => 'bookings', 'action' => 'packages', $package['activity_id'], $package['id']];
		else:
			$url = ['controller' => 'bookings', 'action' => 'private_hire', $package['id']];
		endif;
	?>
	<div class="listing listing--activity <?= !empty($listingClass) ? $listingClass : '' ?>">
		<div class="row">
			<div class="col-xs-12 col-md-2_9 xs-hidden sm-hidden">
				<?php
					$img = (empty($package['Image'][0])) ? 'no-image.png' : $package['Image'][0];
					echo $this->Img->resize($img, ['width' => 670, 'height' => 510, 'crop' => true], ['class' => 'listing__image', 'url' => $url]);
				?>
				<div class="content__spacer xs-visible"></div>
			</div>

			<div class="col-xs-12 col-sm-9 col-md-5_9">
				<div class="row">
					<div class="col-xs-12 col-sm-8">
						<h3>
							<?= $this->Html->link($this->I18n->translate($package, 'name'), $url); ?>
							<?php if ($package['is_special_offer'] === true): ?>
								<br /><small class="color--offer"><?= __d('buzz_bookings', 'Special Offer'); ?></small>
							<?php endif; ?>
						</h3>
					</div>
					<div class="col-xs-12 col-sm-4 xs-text-left va-top text-right fa--senary sm-plus-gutterless--right">
						<?php if (!empty($package['participants'])): ?>
							<div class="listing__stat">
								<?php if ($package['participants'] < 5): ?>
									<?php for ($i = 0; $i < $package['participants']; $i++): ?>
										<i class="fa fa-user"></i>
									<?php endfor; ?>
								<?php else: ?>
									<i class="fa fa-users"></i>
								<?php endif; ?>
								<strong><?= $package['participants']; ?></strong>
							</div>
						<?php else: ?>
							<div class="listing__stat">
								<i class="fa fa-users"></i>
								<strong><?= __d('buzz_bookings', 'Max %d', [$package['max_participants']]); ?></strong>
							</div>
						<?php endif; ?>

						<?php if (!empty($package['start_time'])): ?>
							<div class="listing__stat listing__stat--start-time">
								<i class="fa fa-clock-o"></i> <?= $package['start_time'] ?><br />
								<small>Start Time</small>
							</div>
						<?php endif; ?>
					</div>
				</div>

				<div class="js-read-more">
					<?= $this->I18n->translate($package, 'description'); ?>
				</div>
			</div>

			<?php
				$class = null;
				if ($package['is_special_offer'] === true):
					$class = 'color--offer';
				endif;
			?>
			<div class="col-xs-12 col-sm-3 col-md-2_9 text-center">
				<?php if ($package['price'] === null): ?>
					<span class="listing__price">
						<?= $this->Html->tag('h3', null, ['class' => $class]); ?><?= $package['off_peak_price'] > 0 ? $this->Number->price($package['off_peak_price']) : __d('buzz_bookings', 'Free'); ?><br /></h3>
						<?= __d('buzz_bookings', '(Off Peak)'); ?>
					</span>
					<span class="listing__price">
						<?= $this->Html->tag('h3', null, ['class' => $class]); ?><?= $package['peak_price'] > 0 ? $this->Number->price($package['peak_price']) : __d('buzz_bookings', 'Free'); ?><br /></h3>
						<?= __d('buzz_bookings', '(Peak)'); ?>
					</span>
				<?php else: ?>
					<span class="listing__price">
						<?= $this->Html->tag('h3', null, ['class' => $class]); ?><?= $package['price'] > 0 ? $this->Number->price($package['price']) : __d('buzz_bookings', 'Free'); ?><br /></h3>
					</span>
				<?php endif; ?>
				<?= $this->Fa->link('chevron-circle-right fa-inline', __d('buzz_bookings', 'Book Now'), $url, ['class' => 'button button--fill', 'space' => false]); ?>
			</div>
		</div>

		<?php if (empty($hideHr)): ?>
			<div class="row">
				<div class="xs-hidden col-md-2_9">&nbsp;</div>
				<div class="col-xs-12 col-md-7_9"><hr /></div>
			</div>
		<?php endif; ?>
	</div>
<?php endforeach; ?>
