<?php
$this->extend('/Common/view');
$this->assign('title', __d('buzz_bookings', '%s Booking Step %d', [__d('buzz_bookings', 'Group / Party'), 1]));
echo $this->Html->script(['BuzzBookings.buzz_bookings.min'], ['inline' => false]);
?>

<div class="row">
	<div class="col-xs-12 col-sm-4 col-sm-push-8">
	</div>
	<div class="col-xs-12 col-sm-8 col-sm-pull-4">
		<?php if (Configure::read('BuzzBookings.show_step_1_intro')) : ?>
			<p><?php echo __d('buzz_bookings', 'Select the quantity of %s Packages for you, your family and friends', [$this->I18n->translate($data, 'Activity.name')]); ?></p>
		<?php endif; ?>

		<div class="js-bookings-voucher-booking">
			<label class="left">
				<?php if ($redeemVouchers): ?>
					<?= __d('buzz_bookings', 'Redeem a voucher') ?>
				<?php else: ?>
					<?= __d('buzz_bookings', 'Do you have a voucher?') ?>
				<?php endif ?>
			</label>
			<?php
				echo $this->Form->input(
					'vouchers',
					[
						'label' => __d('buzz_bookings', 'Yes'),
						'div' => 'input checkbox checkbox--custom js-bookings-toggle--vouchers',
						'type' => 'checkbox',
						'checked' => !empty($basket['Booking']['has_vouchers']) || $redeemVouchers
					]
				);
			?>
		</div>
	</div>
</div>
<div class="toggle__content">
	<div class="row">
		<div class="col-xs-6 col-lg-3">
			<h3>Provider</h3>
		</div>

		<div class="col-xs-3 xs-gutterless--left col-lg-2">
			<h3>Voucher Number</h3>
		</div>

		<div class="col-xs-3 xs-gutterless--left col-lg-2 lg-gutterless--right">
			<h3>Expiry Date</h3>
		</div>
	</div>
	<script type="text/javascript">
		var vouchers = <?php echo json_encode($vouchers); ?>;
	</script>
	<?php
		echo $this->element('../Bookings/ajax_voucher', ['activityId' => -1, 'isMultiExperience' => true, 'isPrivateHire' => true]);
	?>
</div>

<?php // If there is a multi-experience voucher in the basket we want to hide all the pacakges. ?>
<?php if (empty($basket['Booking']['has_vouchers']) && $redeemVouchers === false): ?>

	<div class="content__spacer"></div>

	<div class="row js-bookings-private-hire">
		<div class="col-xs-12">
			<?php foreach ($data as $package): ?>
				<?php echo $this->Form->create(null, ['class' => 'js-multi-experience', 'id' => false]); ?>
					<?php echo $this->Form->hidden('Booking.activity_id', ['value' => $package['Activity']['id']]); ?>
					<?php echo $this->element('BuzzBookings.Forms/activity_package', ['data' => $package['ActivityPackage'] + ['Image' => $package['Image']], 'isPrivateHire' => true]); ?>
				<?php echo $this->Form->end(); ?>
				<div class="content__spacer"></div>
			<?php endforeach; ?>
		</div>
	</div>

<?php endif; ?>

<div class="booking__actions">
	<div class="row">
		<div class="col-xs-6">
			<?php
				$previousStep = ['action' => 'index'];
				if ($redeemVouchers) {
					$previousStep[] = 1;
				}
			?>
			<?= $this->Html->link(__d('buzz_bookings', 'Back'), $previousStep, ['class' => 'button button--light background--septenary left']); ?>
		</div>

		<div class="col-xs-6">
		</div>
	</div>
</div>
