<table cellspacing="0" cellpadding="0" border="0" width="100%" class="booking-table">
	<tr>
		<th valign="center" align="left">
			<div>
				<?php echo __d('buzz_bookings', 'Package'); ?>
			</div>
		</th>
		<th valign="bottom" align="left">
			<div>
				<?php echo __d('buzz_bookings', 'Time'); ?>
			</div>
		</th>
		<th valign="bottom" align="left">
			<div>
				<?php echo __d('buzz_bookings', 'Participants'); ?>
			</div>
		</th>
		<th valign="bottom" align="left">
			<div>
				<?php echo __d('buzz_bookings', 'Quantity'); ?>
			</div>
		</th>
		<th valign="bottom" align="left">
			<div>
				<?php echo __d('buzz_bookings', 'Total'); ?>
			</div>
		</th>
	</tr>
	<?php foreach ($data['BookingItem'] as $item): ?>
		<tr>
			<td valign="top" align="left">
				<div>
					<?php if (!empty($item['BookingItemVoucher'])): ?>
						<?php echo $item['BookingItemVoucher']['name']; ?>
					<?php else: ?>
						<?php echo $this->I18n->translate($item, 'ActivityPackage.name'); ?>
					<?php endif; ?>
				</div>
			</td>
			<td valign="top" align="left">
				<div>
					<?php echo date('H:i', strtotime($item['BookingItemPlace'][0]['date_time'])); ?>
				</div>
			</td>
			<td valign="top" align="left">
				<div>
					<?php echo $item['participants']; ?>
				</div>
			</td>
			<td valign="top" align="left">
				<div>
					<?php echo $item['quantity']; ?>
				</div>
			</td>
			<td valign="top" align="left">
				<div>
					<?php echo $this->Number->currency($item['total']); ?>
				</div>
			</td>
		</tr>
	<?php endforeach; ?>
	<?php foreach ($data['BookingExtra'] as $item): ?>
		<tr>
			<td colspan="3" valign="top" align="left">
				<div>
					<?php echo $this->I18n->translate($item, 'Extra.name'); ?>
				</div>
			</td>
			<td valign="top" align="left">
				<div>
					<?php echo $item['quantity']; ?>
				</div>
			</td>
			<td valign="top" align="left">
				<div>
					<?php echo $this->Number->currency($item['total']); ?>
				</div>
			</td>
		</tr>
	<?php endforeach; ?>
	<?php if ($data['Booking']['is_insured']): ?>
		<tr>
			<td colspan="3" valign="top" align="left">
				<div>
					<?php echo __d('buzz_bookings', '\'Any Reason\' Protection'); ?>
				</div>
			</td>
			<td valign="top" align="left">
				<div>
					1
				</div>
			</td>
			<td valign="top" align="left">
				<div>
					<?php echo $this->Number->currency($data['Booking']['insurance_cost']); ?>
				</div>
			</td>
		</tr>
	<?php endif; ?>

	<?php if ($data['Booking']['discount'] > 0): ?>

		<tr>
			<td valign="top" align="right" colspan="4" style="padding:25px 15px;">
				<div>
					<?php echo __d('buzz_bookings', 'Sub-Total'); ?>
				</div>
			</td>
			<td valign="top" align="left" style="padding:25px 15px;">
				<div>
					<?php echo $this->Number->currency($data['Booking']['total_cost'] + $data['Booking']['discount']); ?>
				</div>
			</td>
		</tr>

		<tr>
			<td valign="top" align="right" colspan="4" style="padding:25px 15px;">
				<div>
					<strong><?php echo __d('buzz_bookings', 'Discount'); ?></strong>
				</div>
			</td>
			<td valign="top" align="left" style="padding:25px 15px;">
				<div>
					<strong><?php echo $this->Number->currency($data['Booking']['discount']); ?></strong>
				</div>
			</td>
		</tr>

	<?php endif; ?>

	<tr>
		<td valign="top" align="right" colspan="4" style="padding:25px 15px;">
			<div>
				<strong><?php echo __d('buzz_bookings', 'Total Cost'); ?></strong>
			</div>
		</td>
		<td valign="top" align="left" style="padding:25px 15px;">
			<div>
				<strong><?php echo $this->Number->currency($data['Booking']['total_cost']); ?></strong>
			</div>
		</td>
	</tr>
	<tr><td colspan="5" class="hr">&nbsp;</td></tr>
</table>
