<?php

App::uses('BuzzBookingsAppModel', 'BuzzBookings.Model');

class BookingItem extends BuzzBookingsAppModel {

/**
 * Belongs to associations
 *
 * @var array
 */
	public $belongsTo = array(
		'ActivityPackage' => array(
			'className' => 'BuzzBookings.ActivityPackage'
		),
		'Booking' => array(
			'className' => 'BuzzBookings.Booking'
		)
	);

/**
 * Has one associations
 *
 * @var array
 */
	public $hasOne = array(
		'BookingItemVoucher' => array(
			'className' => 'BuzzBookings.BookingItemVoucher',
			'dependent' => true
		)
	);

/**
 * Has many associations
 *
 * @var array
 */
	public $hasMany = array(
		'BookingItemPlace' => array(
			'className' => 'BuzzBookings.BookingItemPlace',
			'dependent' => true
		)
	);

}
