<?php

App::uses('ConditionsController', 'BuzzConditions.Controller');

class BookingConditionsController extends ConditionsController {

	public $conditionModel = 'Booking';

	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		$newFields['Condition.has_voucher'] = array(
			'type' => 'boolean',
			'default' => '0',
			'label' => 'Only show if a voucher has been redeemed',
			'length' => 1
		);

		return ArrayUtil::addAfter($fields, 'Condition.content', $newFields);
	}
}
