<?php
class BuzzBookingsAddedColumnsForDebugging extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'BuzzBookings_added_columns_for_debugging';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'booking_item_places' => array(
					'created' => array('type' => 'datetime', 'null' => true, 'default' => null, 'after' => 'item_unit_cost'),
					'modified' => array('type' => 'datetime', 'null' => true, 'default' => null, 'after' => 'created'),
				),
				'bookings' => array(
					'ip_address' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'utf8_unicode_ci', 'charset' => 'utf8', 'after' => 'is_removed'),
					'user_agent' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 100, 'collate' => 'utf8_unicode_ci', 'charset' => 'utf8', 'after' => 'ip_address'),
				),
			),
		),
		'down' => array(
			'drop_field' => array(
				'booking_item_places' => array('created', 'modified'),
				'bookings' => array('ip_address', 'user_agent'),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
