<?php
class BuzzBookingsAddedMissingApiReferenceColumn extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'BuzzBookings_added_missing_api_reference_column';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'booking_item_places' => array(
					'api_activity_reference' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'latin1_swedish_ci', 'charset' => 'latin1', 'after' => 'booking_item_id'),
				),
			),
		),
		'down' => array(
			'drop_field' => array(
				'booking_item_places' => array('api_activity_reference'),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction === 'up') {
			// Need to move data to the new column and reset old one.
			$BookingItemPlace = ClassRegistry::init('BuzzBookings.BookingItemPlace');
			$BookingItemPlace->updateAll(
				['BookingItemPlace.api_activity_reference' => 'BookingItemPlace.api_reference']
			);
			$BookingItemPlace->updateAll(
				['BookingItemPlace.api_reference' => null],
				['BookingItemPlace.api_activity_reference = BookingItemPlace.api_reference']
			);
		}
		return true;
	}
}
