<?php
class BuzzBookingsUpdatedTables extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'BuzzBookings_updated_tables';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'booking_items' => array(
					'is_upsell' => array('type' => 'boolean', 'null' => false, 'default' => '0', 'after' => 'total'),
				),
				'bookings' => array(
					'customer_address_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false, 'after' => 'activity_id'),
				),
			),
		),
		'down' => array(
			'drop_field' => array(
				'booking_items' => array('is_upsell'),
				'bookings' => array('customer_address_id'),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction === 'up') {
			$EmailGroup = ClassRegistry::init('BuzzEmails.EmailGroup');
			$data = array(
				'name' => 'Bookings'
			);
			$EmailGroup->save($data);
			$data = array(
				array(
					'name' => 'Booking Confirmation',
					'system_name' => 'BuzzBookings.confirmation_email',
					'email_group_id' => $EmailGroup->id,
					'subject' => 'Your Booking {salesRef}',
					'content' => '<p>Hi {firstName},</p><p><strong>Your Sales Reference Number is: {salesRef}</strong></p><p>Your booking is for {date} at {time} check in at {checkin}.</p><p>{==details==}</p>',
					'required_tokens' => '["salesRef","==details==","checkin","date","time"]',
					'optional_tokens' => '["fullName","firstName","lastName"]'
				),
				array(
					'name' => 'Booking Fallout Email',
					'system_name' => 'BuzzBookings.fallout_email',
					'email_group_id' => $EmailGroup->id,
					'subject' => 'Cancelled Booking Details for {date}',
					'content' => '<p>Hi,</p><p>Your booking would have been for {date} at {time} check in at {checkin}.</p><p>{==details==}</p><p>Do you want to come back and continue with this booking? <a href="{url}">Click here to book this</a></p>',
					'required_tokens' => '["url","==details==","checkin","date","time"]',
					'optional_tokens' => ''
				)
			);
			ClassRegistry::init('BuzzEmails.Email')->saveMany($data);
		}
		return true;
	}
}
