<?php
$this->extend('/Common/view');
$this->assign('title', __d('buzz_bookings', '%s Booking Step %d', [$this->I18n->translate($data, 'Activity.name'), 1]));
if ($data['Activity']['is_hidden_activity'] === true):
	$this->assign('meta', '<meta name="robots" content="noindex, nofollow" />');
endif;
echo $this->Html->script(['BuzzBookings.buzz_bookings.min'], ['inline' => false]);
?>

<?php if (empty($data['Activity']['is_hidden_activity'])): ?>
	<div class="row">
		<div class="col-xs-12 col-sm-4 col-sm-push-8">
			<?php if ($hasPrivateHirePackages === true && $data['Activity']['show_private_hire'] === true): ?>
				<div class="outline--secondary background--white padding-gutters-1_2">
					<div class="row">
						<div class="col-xs-12 col-md-6 md-plus-gutterless--right text-center">
							<h3 class="md-plus-left gutter-top"><?php echo __d('buzz_bookings', 'Want Group / Party Booking?'); ?></h3>
						</div>

						<div class="col-xs-12 col-md-6">
							<?php
								echo $this->Fa->link(
									'chevron-circle-right fa-inline',
									__d('buzz_bookings', 'Book Now'),
									['action' => 'private_hire'],
									['class' => 'button button--fill md-plus-right']
								);
							?>
						</div>
					</div>
				</div>
				<div class="content__spacer"></div>
			<?php endif; ?>
		</div>
		<div class="col-xs-12 col-sm-8 col-sm-pull-4">
			<?php if (Configure::read('BuzzBookings.show_step_1_intro')) : ?>
				<p><?php echo __d('buzz_bookings', 'Select the quantity of %s Packages for you, your family and friends', [$this->I18n->translate($data, 'Activity.name')]); ?></p>
			<?php endif; ?>

			<?= $this->Settings->string('buzz_bookings_step_1_intro') ?>

			<?php echo $this->I18n->translate($data, 'Activity.step_1_text'); ?>

			<div class="js-bookings-voucher-booking">
				<label class="left">
					<?php if ($redeemVouchers): ?>
						<?= __d('buzz_bookings', 'Redeem a voucher') ?>
					<?php else: ?>
						<?= __d('buzz_bookings', 'Do you have a voucher?') ?>
					<?php endif ?>
				</label>
				<?php
					echo $this->Form->input(
						'vouchers',
						[
							'label' => __d('buzz_bookings', 'Yes'),
							'div' => 'input checkbox checkbox--custom js-bookings-toggle--vouchers',
							'type' => 'checkbox',
							'checked' => !empty($basket['Booking']['has_vouchers']) || $redeemVouchers
						]
					);
				?>
			</div>
		</div>
	</div>
	<div class="toggle__content">
		<div class="row">
			<div class="col-xs-6 col-lg-3">
				<h3><?= __d('buzz_bookings', 'Provider') ?></h3>
			</div>

			<div class="col-xs-3 xs-gutterless--left col-lg-2">
				<h3><?= __d('buzz_bookings', 'Voucher Number') ?></h3>
			</div>

			<div class="col-xs-3 xs-gutterless--left col-lg-2 lg-gutterless--right">
				<h3><?= __d('buzz_bookings', 'Expiry Date') ?></h3>
			</div>
		</div>
		<script type="text/javascript">
			var vouchers = <?php echo json_encode($vouchers); ?>;
		</script>
		<?php
			if (!empty($basket['Booking']['has_vouchers'])):
				$numberOfVouchers = count(Hash::extract($basket, 'BookingItem.{n}.BookingItemVoucher.id'));
				$i = 0;
				foreach ($basket['BookingItem'] as $bookingItem):
					if (!empty($bookingItem['BookingItemVoucher'])):
						++$i;
						echo $this->element(
							'../Bookings/ajax_voucher_added',
							[
								'voucher' => $bookingItem['BookingItemVoucher'],
								'activityId' => $data['Activity']['id'],
								'hideButton' => $i < $numberOfVouchers || $isMultiExperience === true
							]
						);
					endif;
				endforeach;
			else:
				echo $this->element('../Bookings/ajax_voucher', ['activityId' => $data['Activity']['id']]);
			endif;
		?>
	</div>
<?php endif; ?>

<?php // If there is a multi-experience voucher in the basket we want to hide all the pacakges. ?>
<?php if ($isMultiExperience === false || empty($basket['Booking']['has_vouchers'])): ?>

	<?php echo $this->Form->create(null, ['class' => $isMultiExperience ? 'js-multi-experience' : null, 'data-proceed' => 0]); ?>

	<?php echo $this->Form->hidden('Booking.activity_id'); ?>

	<div class="js-buzz-bookings-packages<?= $redeemVouchers ? ' hidden' : null ?>">

		<div class="row js-has-valid-vouchers hidden">
			<div class="col-xs-12">
				<h2 class="h3"><?= __d('buzz_bookings', 'Note: additional places will be booked on the same session as your voucher places. Select only the quantity of extra places to add below.') ?></h2>
			</div>
		</div>

		<div class="content__spacer"></div>

		<div class="row">
			<div class="col-xs-12">
				<?php foreach ($data['ActivityPackage'] as $package): ?>
					<?php echo $this->element('BuzzBookings.Forms/activity_package', ['data' => $package]); ?>
					<div class="content__spacer"></div>
				<?php endforeach; ?>
			</div>
		</div>

	</div>

	<div class="booking__actions">
		<div class="row">
			<div class="col-xs-4">
				<?= $this->Html->link(__d('buzz_bookings', 'Back'), $previousStep, ['class' => 'button button--light background--septenary left']); ?>
			</div>

			<div class="col-xs-8">
				<?= $this->Form->button(__d('buzz_bookings', 'Proceed'), ['class' => 'button button--dark background--senary right js-button-proceed button--booking-proceed']); ?>
				<?php if ($isMultiExperience === false): ?>
					<?= $this->Form->button(__d('buzz_bookings', 'Buy extra places'), ['class' => 'button button--dark background--senary right js-extra-places hidden']); ?>
				<?php endif; ?>
			</div>
		</div>
	</div>

	<?php echo $this->Form->end(); ?>

<?php endif; ?>
