<div class="row" id="available-times">
	<div class="col-xs-12">
		<h2><?php echo __d('buzz_bookings', 'Available times for %s', [$this->Time->i18nFormat($date, '%e %B %Y')]); ?></h2>
	</div>

	<div class="col-xs-12">
		<div class="input radio radio--times">
			<input type="hidden" name="data[Booking][time]" id="BookingTime_" value="" />
			<div class="radios__wrapper">
				<?php foreach ($data as $key => $val): ?>
					<div class="radio-wrapper">
						<?php
							$checkin = strtotime($date . ' ' . $val['time']) -  $val['check_in'] * 60;
							echo $this->Html->tag(
								'input',
								null,
								[
									'name' => 'data[Booking][time]',
									'id' => 'BookingTime' . $key,
									'value' => $key,
									'type' => 'radio',
									'class' => 'required radio--booking__time ' . ($val['peak'] === true ? 'radio--booking__time--peak' : ''),
									'data-checkin' => date('H:i', $checkin)
								]
							);
							echo $this->Form->label('Booking.time.' . $key, $val['time']);
						?>
					</div>
				<?php endforeach; ?>
			</div>
		</div>

		<div class="js-bookings-checkin" data-text="<?php echo __d('buzz_bookings', 'You will need to arrive no later than %s.'); ?>"></div>

		<div class="js-activity-times hidden">
			<h3><?php echo __d('buzz_bookings', 'Your activity times'); ?></h3>
			<?php foreach ($data as $key => $value): ?>
				<?php if (count($value['activities']) > 1): ?>
					<ul class="js-activity-times--<?php echo $key; ?> hidden no-bullets">
						<?php foreach ($value['activities'] as $activity): ?>
							<li><small><strong><?php echo $activity['description']; ?>:</strong> <?php echo $activity['from_time'] ?></small></li>
						<?php endforeach; ?>
					</ul>
				<?php endif; ?>
			<?php endforeach; ?>
		</div>
	</div>

	<div class="col-xs-12">
		<div class="booking_key">
			<h3><?= __d('buzz_bookings', 'Key:') ?></h3>
			<br class="xs-visible" />

			<?= $this->Html->image('booking_key-4.png'); ?>
			<?= __d('buzz_bookings', 'Off Peak time') ?>
			<br class="xs-visible" />

			<?= $this->Html->image('booking_key-5.png'); ?>
			<?= __d('buzz_bookings', 'Peak time') ?>
			<br class="xs-visible" />

			<?= $this->Html->image('booking_key-6.png'); ?>
			<?= __d('buzz_bookings', 'Selected time') ?>
			<br class="xs-visible" />
		</div>
	</div>
</div>
