<?php $this->Extend('/Scaffolds/admin_form'); ?>
<?php $this->Append('additionalFormTabs'); ?>

	<?php
		if (!empty($this->request->data['Booking']['completed_date'])):
			echo $this->Html->tag('div', $this->element('admin_purchase_details'), ['class' => 'tab__content', 'data-title' => __d('buzz_bookings', 'Details')]);
		endif;
	?>

	<?php
		if (
			!empty($this->request->data['Booking']['api_log'])
			&& (int)$authUser['UserGroup']['id'] === 1
		):
			echo $this->Html->tag(
				'div',
				'<pre>' .  print_r(json_decode($this->request->data['Booking']['api_log']), 1) . '</pre>',
				['class' => 'tab__content', 'data-title' => __d('buzz_bookings', 'API Errors')]
			);
		endif;
		if (!empty($apiCalls)):
		?>
			<div class="tab__content" data-title="<?=__d('buzz_bookings', 'API Calls')?>">
				<?=$this->element('BuzzSource.api_log')?>
				<?php if (! empty($itemApiCalls)): ?>
					<hr />
					<h4>Booking Item API Calls</h4>
					<?=$this->element('BuzzSource.api_log', array('apiCalls' => $itemApiCalls))?>
				<?php endif; ?>

			</div>

		<?php
		endif;
	?>

<?php $this->end(); // additionalFormTabs end ?>

<?php

	echo $this->Form->addField('Booking.id', array(
		'type' => 'hidden'
	));

	echo $this->Form->addField(
		'Booking.sales_ref',
		array(
			'type' => 'string',
			'label' => __d('buzz_bookings', 'Sales Ref'),
			'displayonly' => true
		)
	);

	echo $this->Form->addField(
		'Booking.booking_state_id',
		array(
			'type' => 'select',
			'label' => __d('buzz_bookings', 'Status'),
			'empty' => false,
			'displayonly' => true
		)
	);

	echo $this->Form->addField(
		'Booking.completed_date',
		array(
			'type' => 'date',
			'label' => __d('buzz_bookings', 'Completed Date'),
			'displayonly' => true
		)
	);

	echo $this->Form->input('CustomerAddress.id');

	echo $this->Form->addField(
		'CustomerAddress.full_name',
		array(
			'type' => 'string',
			'label' => __d('buzz_bookings', 'Customer'),
			'displayonly' => true
		)
	);

	echo $this->Form->addField(
		'CustomerAddress.email',
		array(
			'type' => 'email',
			'label' => __d('buzz_bookings', 'Email Address')
		)
	);

	echo $this->Form->addField(
		'CustomerAddress.telephone',
		array(
			'type' => 'tel',
			'label' => __d('buzz_bookings', 'Telephone')
		)
	);
?>

<div class="field">
	<div class="field__label"><?php echo __d('buzz_bookings', 'Total Cost'); ?></div>
	<div class="field__value">
		<?php echo $this->Number->currency($this->request->data['Booking']['total_cost']); ?>
	</div>
</div>
