<?php

class ActivityTest extends CakeTestCase {

	public $fixtures = array(
		'plugin.buzz_adverts.Advert',
		'plugin.buzz_adverts.AdvertRelation',
		'plugin.buzz_bookings.Activity',
		'plugin.buzz_bookings.ActivityPackage',
		'plugin.buzz_bookings.BuzzBookingsDocument',
		'plugin.buzz_bookings.BuzzBookingsMetaData',
		'plugin.buzz_theme.Theme',
		'plugin.buzz_translate.Translation',
		'plugin.ev_core.Image',
		'plugin.ev_core.Tab',
	);

	public function setUp() {
		parent::setUp();
		$this->Activity = ClassRegistry::init('BuzzBookings.Activity');
	}

	public function testGetListed() {
		$result = $this->Activity->getListed();
		$this->assertCount(4, $result);
		return;
	}

	public function testReadForView() {
		$result = $this->Activity->readForView(1);
		$this->assertEquals('Activity #1', $result['Activity']['name']);
		$this->assertCount(2, $result['ActivityPackage']);
		return;
	}

	public function testOnlyBookableActivity() {
		$result = $this->Activity->onlyBookableActivity();
		$this->assertFalse($result);
		return;
	}

	public function testGetBookableActivity() {
		$result = $this->Activity->getBookableActivity(1);
		$this->assertInternalType('array', $result);
		$result = $this->Activity->getBookableActivity(2);
		$this->assertFalse($result);
		return;
	}

	public function testListNonMultiExperienceActivities() {
		$this->Activity = $this->getMockForModel('Activity', ['getMultiExperience']);
		$this->Activity->expects($this->any())->method('getMultiExperience')->will($this->returnValue(8));
		$result = $this->Activity->listNonMultiExperienceActivities();
		$this->assertCount(7, $result);

		return;
	}

}
