<?php
class BuzzbookingAddNotificatonEmailData extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'buzzbooking_add_notification_email_data';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(),
		'down' => array(),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {

		if ($direction === 'up') {
			$data = array(
				array(
					'name' => 'Booking Confirmation',
					'system_name' => 'BuzzBookings.notification_email',
					'email_group_id' => 1,
					'subject' => 'A new booking has been made.',
					'content' => '<p>Hello,</p><p>A new activity booking has been made. Please find the booking details below.</p><p><strong>Sales Reference Number: {salesRef}</strong></p><p>This booking is for {date} at {time} check in at {checkin}.</p><p>{==details==}</p>',
					'required_tokens' => '["salesRef","==details==","checkin","date","time"]'
				)
			);
			ClassRegistry::init('BuzzEmails.Email')->saveMany($data);
		}

		return true;
	}
}
