<?php
class BuzzBookingsAddedEmailToBookingsTable extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'BuzzBookings_added_email_to_bookings_table';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'bookings' => array(
					'email' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 254, 'collate' => 'utf8_general_ci', 'comment' => 'Used for fallout customers', 'charset' => 'utf8', 'after' => 'booking_state_id'),
				),
			),
			'alter_field' => array(
				'bookings' => array(
					'tableParameters' => array('charset' => 'utf8', 'collate' => 'utf8_unicode_ci'),
				),
			),
		),
		'down' => array(
			'drop_field' => array(
				'bookings' => array('email'),
			),
			'alter_field' => array(
				'bookings' => array(
					'tableParameters' => array('charset' => 'latin1', 'collate' => 'latin1_swedish_ci', 'engine' => 'InnoDB'),
				),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
