<?php
class BuzzBookingsAddedParticipantsColumns extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'BuzzBookings_added_participants_columns';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'activity_packages' => array(
					'participants' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false, 'after' => 'is_special_offer'),
					'max_participants' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false, 'after' => 'participants'),
				),
			),
			'alter_field' => array(
				'activity_packages' => array(
					'is_active' => array('type' => 'boolean', 'null' => false, 'default' => '1'),
					'is_removed' => array('type' => 'boolean', 'null' => false, 'default' => '0'),
				),
			),
		),
		'down' => array(
			'drop_field' => array(
				'activity_packages' => array('participants', 'max_participants'),
			),
			'alter_field' => array(
				'activity_packages' => array(
					'is_active' => array('type' => 'boolean', 'null' => true, 'default' => null),
					'is_removed' => array('type' => 'boolean', 'null' => true, 'default' => null),
				),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
