var buzzBookingDate = '';
jQuery(function($) {
	initBookingsVouchers();
	initBookingsDates();
	initBookingsMultiExperience();
	initBookingsPrivateHire();
	initBookingsExtras();
});

function initBookingsVouchers() {

	$('body').on('change', '.js-bookings-toggle--vouchers', function(){
		var $toggleContent = $(this).parent().parent().parent().next('.toggle__content');
		var $_this = $(this);
		if ($('input', this).is(':checked')) {
			$toggleContent.slideDown(600);
			$_this.fadeOut(600);
		}
	});
	$('.js-bookings-toggle--vouchers').trigger('change');

	var $checkVoucherBtn = $('.js-bookings-check-voucher');
	$checkVoucherBtn.attr('disabled', true);
	$('body').on('change', '.js-bookings-voucher-provider select', function(){

		$('.js-bookings-select-voucher').empty();

		if (vouchers.hasOwnProperty($(this).val())) {

			var $select = $('<select />').attr('name', 'data[BookingItemVoucher][api_voucher_id]');

			$('<option />').text('Please select').val(0).appendTo($select);
			$.each(vouchers[$(this).val()], function(key, val){
				$select.append($('<option />').val(key).text(val));
			});

			$('.js-bookings-select-voucher').append($select);
			customFormElements();
		}

	});
	$('.js-bookings-voucher-provider select').trigger('change');
	$('body').on('change', '.js-bookings-add-voucher-form', function(){
		if (
			$('input, select', this).filter(function(){
				console.log($(this).attr('name'));
				console.log($(this).val());
				return !$(this).val() || $(this).val() == 0;
			}).length === 0
		) {
			$checkVoucherBtn.attr('disabled', false);
		} else {
			$checkVoucherBtn.attr('disabled', true);
		}
	});
	$('body').on('click', '.js-bookings-check-voucher', function(e){
		e.preventDefault();
		var $form = $(this).closest('form');
		$.ajax({
			'cache': false,
			'url': $form.attr('action'),
			'data': $form.serialize()
		}).done(function(data){
			$('.js-bookings-add-voucher-form').replaceWith(data);
			customFormElements();
			$checkVoucherBtn.attr('disabled', true);
			$('.js-bookings-voucher-provider select').trigger('change');
		});
	});
	$('body').on('click', '.js-bookings-add-voucher', function(e){
		e.preventDefault();
		var $row = $(this).closest('.row');
		$.ajax({
			'context': this,
			'cache': false,
			'url': $(this).data('url')
		}).done(function(data){
			$row.replaceWith(data);
			customFormElements();
			$checkVoucherBtn.attr('disabled', true);
			$('.js-bookings-voucher-provider select').trigger('change');
		});
	});
	$('body').on('click', '.js-bookings-remove-voucher', function(e){
		e.preventDefault();
		var $row = $(this).closest('.row');
		$row.remove();
		$.ajax({
			'context': this,
			'cache': false,
			'url': $(this).attr('href')
		}).done(function(data){
			$row.remove();
		});
	});
}

function initBookingsDates() {

	var $form = $('.js-bookings-availability');

	if (!$form.length) {
		return;
	}

	if ($form.hasClass('ajax-loader')) {
		$form.toggleClass('ajax-loader ajax-loading');
	}

	$.ajax({
		'cache': false,
		'url': $form.data('src')
	}).done(function(data){
		$form.removeClass('ajax-loading');
		$form.append(data);
		customFormElements();
		BookingsSelectDate();
	});

	BookingsSelectTime();

}

function BookingsSelectDate() {
	var $date = $('.js-booking-date');

	var $form = $('#BookingDateForm');

	$form.on('change', '.radio--times', function(){
		$('button', $form).removeAttr('disabled');
	});

	$(document).on('change', $date, function(){
		if (buzzBookingDate !== $date.val()) {
			buzzBookingDate = $date.val();
			$.ajax({
				'cache': false,
				'url': $date.data('src') + '/' + $date.val()
			}).done(function(data){
				$('.js-booking-times').html(data);
				// Radio for time slots in booking process
				if ($(".radio--times").length) {
					if (!$.fn.customRadio) {
						console.log("Main: jquery.customRadio.js must be loaded!");
						return;
					}
					$(".radio--times").customRadio();
				}
			});
			$('button', $form).attr('disabled', 'disabled');
		}
	});
	$date.trigger('change');
}

function BookingsSelectTime() {
	$(document).on('click', '.radio--booking__time', function() {
		var $arrivalTimeNotice = $('.js-bookings-checkin');
		var text = $arrivalTimeNotice.data('text').replace(/%s/, $(this).data('checkin'));
		$arrivalTimeNotice.html('<p><strong>' + __('Remember') + ':</strong> ' + text + '</p>');

		$activityTimes = $('.js-activity-times--' + $(this).val());
		$('.js-activity-times ul').addClass('hidden');
		if ($activityTimes.length) {
			$activityTimes.closest('.js-activity-times').removeClass('hidden');
			$activityTimes.removeClass('hidden');
		} else {
			$activityTimes.closest('.js-activity-times').addClass('hidden');
		}
	});
}

function initBookingsMultiExperience() {
	$form = $('#BookingPackagesForm');
	if ($form.hasClass('js-multi-experience') === false) {
		return;
	}
	$form.on('change', 'select', function(){
		var count = 0;
		$('select', $form).each(function(){
			count += parseInt($(this).val());
		});
		if (count === 0) {
			$('.listing--activity').removeClass('listing--disabled');
			$('select', $form).removeAttr('disabled');
			$('.js-bookings-voucher-booking').fadeIn(600);
		} else {
			$('.listing--activity').addClass('listing--disabled');
			$(this).closest('.listing--activity').removeClass('listing--disabled');
			$('select', $form).attr('disabled', true);
			$(this).removeAttr('disabled');
			$('.js-bookings-voucher-booking').fadeOut(600);
		}
	});
	$('select', $form).each(function(){
		if ($(this).val() > 0) {
			$(this).trigger('change');
		}
	});

	$('body').on('change', '.js-bookings-toggle--vouchers', function(){
		if ($('input', this).is(':checked')) {
			$form.fadeOut(600);
		}
	});
}

function initBookingsPrivateHire() {
	var $packages = $('.js-bookings-private-hire');
	if (!$packages.length) {
		return;
	}

	$('body').on('change', '.js-bookings-toggle--vouchers', function(){
		if ($('input', this).is(':checked')) {
			$packages.fadeOut(600);
		}
	});
}

function initBookingsExtras() {
	$form = $('#BookingExtrasForm');
	if (!$form.length) {
		return;
	}
	$('.js-listing-bookable-upsell', $form).on('change', 'select', function(){
		var count = 0;
		$('select', $form).each(function(){
			count += parseInt($(this).val());
		});
		if (count === 0) {
			$('.js-listing-bookable-upsell').removeClass('listing--disabled');
			$('.js-listing-bookable-upsell select', $form).removeAttr('disabled');
		} else {
			$('.js-listing-bookable-upsell').addClass('listing--disabled');
			$(this).closest('.listing--activity').removeClass('listing--disabled');
			$('.js-listing-bookable-upsell select', $form).attr('disabled', true);
			$(this).removeAttr('disabled');
		}
	});
	$('.js-listing-bookable-upsell select', $form).each(function(){
		if ($(this).val() > 0) {
			$(this).trigger('change');
		}
	});
}
