<div class="row">
	<div class="col-xs-12">
		<div class="outline--septenary outline--thin background--white padding-gutters-1_2 basket">

			<div class="row">
				<div class="col-xs-12 col-sm-6">
					<h3><?php echo __dn('buzz_bookings', 'You are booking: %d item', 'You are booking: %d items', $data['Booking']['total_items'], [$data['Booking']['total_items']]); ?></h3>
				</div>

				<div class="col-xs-12 col-sm-6">
					<div class="button background--nonary sm-plus-right toggle"><?php echo __d('buzz_bookings', 'Expand'); ?> <i class="fa fa-chevron-circle-down"></i></div>
				</div>
			</div>

			<div class="toggle__content">

				<?php if (!empty($data['Booking']['booking_date'])): ?>
					<div class="row">
						<div class="col-xs-12">
							<h3><?php echo __d('buzz_bookings', 'Your booking for %s', [$this->Time->i18nFormat($data['Booking']['booking_date'], '%e %B %Y')]) ?></h3>
							<p><?php echo __d('buzz_bookings', 'Check-in time: %s', [$data['Booking']['check_in_time']]); ?></p>
						</div>
					</div>
				<?php endif; ?>

				<?php foreach ($data['BookingItem'] as $item): ?>
					<div class="listing listing--booking">
						<div class="row">
							<div class="col-xs-12 col-sm-5 xs-extra-gutters-1 sm-plus-extra-gutters-2--left">
								<h3>
									<?php if (!empty($item['BookingItemVoucher'])): ?>
										<?php echo $item['BookingItemVoucher']['name']; ?>
									<?php else: ?>
										<?php echo $this->I18n->translate($item, 'ActivityPackage.name'); ?>
									<?php endif; ?>
								</h3>
							</div>
							<div class="col-xs-12 xs-extra-gutters-1 col-sm-2">
								<?php if (!empty($item['BookingItemPlace'][0]['date_time'])): ?>
									<strong><?php echo __d('buzz_bookings', 'Time:'); ?></strong>
									<span class="h3"><?php echo date('H:i', strtotime($item['BookingItemPlace'][0]['date_time'])); ?></span>
								<?php endif; ?>
							</div>
							<div class="col-xs-12 xs-extra-gutters-1 col-sm-1 xs-text-left text-right fa--senary">
								<?php if (!empty($item['participants'])): ?>
									<?php if ($item['participants'] < 5): ?>
										<?php for ($i = 0; $i < $item['participants']; $i++): ?>
											<i class="fa fa-user"></i>
										<?php endfor; ?>
									<?php else: ?>
										<i class="fa fa-users"></i>
									<?php endif; ?>
									<strong><?php echo $item['participants']; ?></strong>
								<?php elseif (!empty($item['ActivityPackage']['max_participants'])): ?>
									<?php $footnote = true; ?>
									<i class="fa fa-users"></i>
									<strong><?php echo $item['ActivityPackage']['max_participants']; ?> <sup>*</sup></strong>
								<?php endif; ?>
							</div>
							<div class="col-xs-12 xs-extra-gutters-1 col-sm-2 gutterless sm-plus-text-center">
								<strong><?php echo __d('buzz_bookings', 'Quantity:') . ' ' . $item['quantity']; ?></strong>
							</div>
							<div class="col-xs-12 xs-extra-gutters-1 col-sm-2">
								<?php if (!empty($item['BookingItemVoucher'])): ?>
									<span class="color--senary"><strong><?php echo __d('buzz_bookings', 'Redeeming Voucher'); ?></strong></span>
								<?php elseif (!empty($item['total'])): ?>
									<strong><?php echo __d('buzz_bookings', 'Price:'); ?></strong>
									<span class="large"><?php echo $this->Number->currency($item['total']); ?></span>
								<?php endif; ?>
							</div>
						</div>
					</div>
				<?php endforeach; ?>



				<?php foreach ($data['BookingExtra'] as $item): ?>
					<div class="listing listing--booking">
						<div class="row">
							<div class="col-xs-12 col-sm-5 xs-extra-gutters-1 sm-plus-extra-gutters-2--left">
								<h3><?php echo $this->I18n->translate($item, 'Extra.name'); ?></h3>
							</div>
							<div class="col-xs-12 xs-extra-gutters-1 col-sm-3">
								<!-- time -->
							</div>
							<div class="col-xs-12 xs-extra-gutters-1 col-sm-2 gutterless sm-plus-text-center">
								<strong><?php echo __d('buzz_bookings', 'Quantity:') . ' ' . $item['quantity']; ?></strong>
							</div>
							<div class="col-xs-12 xs-extra-gutters-1 col-sm-2">
								<?php if (!empty($item['total'])): ?>
									<strong><?php echo __d('buzz_bookings', 'Price:'); ?></strong>
									<span class="large"><?php echo $this->Number->currency($item['total']); ?></span>
								<?php endif; ?>
							</div>
						</div>
					</div>
				<?php endforeach; ?>

				<?php if (!empty($footnote)): ?>
					<p><small>* <?php echo __d('buzz_bookings', 'Maximum number of participants'); ?></small></p>
				<?php endif; ?>
			</div>

			<?php if (!empty($data['Booking']['booking_date'])): ?>
				<div class="row">
					<div class="col-xs-12 col-sm-10">
						<?php if (!empty($timeoutRedirect)): ?>
							<div class="content__spacer--small">&nbsp;</div>
							<p>
								<?php echo __d('buzz_bookings', 'Time remaining to complete this booking:'); ?>
								<span class="js-countdown color--warning" data-countdown-seconds="<?php echo $timeRemaining; ?>" data-countdown-load-url="<?php echo $this->Html->url($timeoutRedirect); ?>"></span>
							</p>
						<?php endif; ?>
					</div>
					<div class="col-xs-12 col-sm-2 basket__total">
						<strong><?php echo __d('buzz_bookings', 'Total:'); ?> <span class="large"><?php echo $this->Number->currency($data['Booking']['total_cost']); ?></strong>
					</div>
				</div>
				<?php endif; ?>

		</div>

		<div class="content__spacer"></div>
	</div>
</div>
