<div class="gw field">

	<div class="g one-half">
		<?php
			echo $this->Html->tag('h3', __d('buzz_bookings', 'Customer Address'));
			echo $this->Address->format(
				$this->request->data['CustomerAddress'],
				[
					'address_line_1',
					'address_line_2',
					'address_line_3',
					'city',
					'postcode',
					'Country.name'
				]
			);
		?>
	</div>

</div>
<div class="gw field">

	<div class="g">
		<table class='data-table'>
			<thead>
				<tr>
					<th><?php echo __d('buzz_bookings', 'Package'); ?></th>
					<th><?php echo __d('buzz_bookings', 'Upsell'); ?></th>
					<th><?php echo __d('buzz_bookings', 'Date'); ?></th>
					<th><?php echo __d('buzz_bookings', 'Time'); ?></th>
					<th><?php echo __d('buzz_bookings', 'Participants'); ?></th>
					<th><?php echo __d('buzz_bookings', 'Quantity'); ?></th>
					<th><?php echo __d('buzz_bookings', 'Total'); ?></th>
				</tr>
			</thead>
			<tbody>
				<?php foreach ($this->request->data['BookingItem'] as $item): ?>
					<tr>
						<td>
							<?php if (!empty($item['BookingItemVoucher'])): ?>
								<?php echo $item['BookingItemVoucher']['name']; ?>
							<?php else: ?>
								<?php echo $item['ActivityPackage']['name']; ?>
							<?php endif; ?>
						</td>
						<td class="center">
							<?php if (!empty($item['is_upsell'])): ?>
								<i class="fa fa-check"></i>
							<?php endif; ?>
						</td>
						<td>
							<?php echo date('d/m/y', strtotime($item['BookingItemPlace'][0]['date_time'])); ?>
						</td>
						<td>
							<?php echo date('H:i', strtotime($item['BookingItemPlace'][0]['date_time'])); ?>
						</td>
						<td>
							<?php echo $item['participants'] ?: __d('buzz_bookings', 'Private Hire'); ?>
						</td>
						<td>
							<?php echo $item['quantity']; ?>
						</td>
						<td>
							<?php echo $this->Number->currency($item['total']); ?>
						</td>
					</tr>
				<?php endforeach; ?>
			</tbody>
			<tfoot>
				<tr>
					<th colspan="5" class="text--right"><?php echo __d('buzz_bookings', 'Total Cost'); ?></th>
					<th><?php echo $this->Number->currency($this->request->data['Booking']['total_cost']); ?></th>
				</tr>
			</tfoot>
		</table>
	</div>

</div>
