<?php foreach ($data['ActivityPackage'] as $package): ?>
	<?php
		if ($package['participants'] > 0):
			$url = ['controller' => 'bookings', 'action' => 'packages', $package['activity_id'], $package['id']];
		else:
			$url = ['controller' => 'bookings', 'action' => 'private_hire', $package['id']];
		endif;
	?>
	<div class="listing listing--activity">
		<div class="row">
			<div class="col-xs-12 col-md-2_9">
				<?php
					$img = (empty($package['Image'][0])) ? 'no-image.png' : $package['Image'][0];
					echo $this->Image->resize($img, ['width' => 670, 'height' => 510, 'crop' => true, 'class' => 'listing__image', 'url' => $url, 'sharpen' => false, 'transparent' => true]);
				?>
				<div class="content__spacer xs-visible"></div>
			</div>

			<div class="col-xs-12 col-sm-9 col-md-5_9">
				<div class="row">
					<div class="col-xs-12 col-sm-8">
						<h3>
							<?php echo $this->Html->link($this->I18n->translate($package, 'name'), $url); ?>
							<?php if ($package['is_special_offer'] === true): ?>
								<br /><small class="color--offer"><?php echo __d('buzz_bookings', 'Special Offer'); ?></small>
							<?php endif; ?>
						</h3>
					</div>
					<div class="col-xs-12 col-sm-4 xs-text-left text-right fa--senary">
						<?php if (!empty($package['participants'])): ?>
							<?php if ($package['participants'] < 5): ?>
								<?php for ($i = 0; $i < $package['participants']; $i++): ?>
									<i class="fa fa-user"></i>
								<?php endfor; ?>
							<?php else: ?>
								<i class="fa fa-users"></i>
							<?php endif; ?>
							<strong><?php echo $package['participants']; ?></strong>
						<?php else: ?>
							<i class="fa fa-users"></i>
							<strong><?php echo __d('buzz_bookings', 'Max %d', [$package['max_participants']]); ?></strong>
						<?php endif; ?>
					</div>
				</div>

				<?php echo $this->I18n->translate($package, 'description'); ?>
			</div>

			<?php
				$class = null;
				if ($package['is_special_offer'] === true):
					$class = 'color--offer';
				endif;
			?>
			<div class="col-xs-12 col-sm-3 col-md-2_9 text-center">
				<?php if ($package['price'] === null): ?>
					<span class="listing__price">
						<?php echo $this->Html->tag('h3', null, ['class' => $class]); ?><?php echo $this->Number->price($package['off_peak_price']); ?><br /></h3>
						<?php echo __d('buzz_bookings', '(Off Peak)'); ?>
					</span>
					<span class="listing__price">
						<?php echo $this->Html->tag('h3', null, ['class' => $class]); ?><?php echo $this->Number->price($package['peak_price']); ?><br /></h3>
						<?php echo __d('buzz_bookings', '(Peak)'); ?>
					</span>
				<?php else: ?>
					<span class="listing__price">
						<?php echo $this->Html->tag('h3', null, ['class' => $class]); ?><?php echo $this->Number->price($package['price']); ?><br /></h3>
					</span>
				<?php endif; ?>
				<?php echo $this->Fa->link('chevron-circle-right fa-inline', __d('buzz_bookings', 'Book Now'), $url, ['class' => 'button button--fill', 'space' => false]); ?>
			</div>
		</div>

		<div class="row">
			<div class="xs-hidden col-md-2_9">&nbsp;</div>
			<div class="col-xs-12 col-md-7_9"><hr /></div>
		</div>
	</div>
<?php endforeach; ?>
