<div class="listing listing--activity listing--booking js-listing-highlight">
	<div class="row">
		<div class="col-xs-12 col-md-2">
			<?php
				$img = (empty($data['Image'][0])) ? 'no-image.png' : $data['Image'][0];
				echo $this->Image->resize($img, ['width' => 670, 'height' => 510, 'crop' => true, 'class' => 'listing__image', 'sharpen' => false, 'transparent' => true]);
			?>
		</div>

		<div class="col-xs-12 col-sm-9 col-md-6">
			<div class="row">
				<div class="col-xs-12 col-sm-8">
					<h3>
						<?php echo $this->I18n->translate($data, 'name'); ?>
						<?php if ($data['is_special_offer'] === true): ?>
							<br /><small class="color--offer"><?php echo __d('buzz_bookings', 'Special Offer'); ?></small>
						<?php endif; ?>
					</h3>
				</div>
				<div class="col-xs-12 col-sm-4 xs-text-left text-right fa--senary">
					<?php if (!empty($data['participants'])): ?>
						<?php if ($data['participants'] < 5): ?>
							<?php for ($i = 0; $i < $data['participants']; $i++): ?>
								<i class="fa fa-user"></i>
							<?php endfor; ?>
						<?php else: ?>
							<i class="fa fa-users"></i>
						<?php endif; ?>
						<strong><?php echo $data['participants']; ?></strong>
					<?php else: ?>
						<i class="fa fa-users"></i>
						<strong><?php echo __d('buzz_bookings', 'Max %d', [$data['max_participants']]); ?></strong>
					<?php endif; ?>
				</div>
			</div>

			<?php echo $this->I18n->translate($data, 'description'); ?>
		</div>

		<?php
			$class = null;
			if ($data['is_special_offer'] === true):
				$class = 'color--offer';
			endif;
		?>
		<div class="col-xs-12 col-sm-3 col-md-4 text-center">
			<?php if ($data['price'] === null): ?>
				<span class="listing__price">
					<?php echo $this->Html->tag('h3', null, ['class' => $class]); ?><?php echo $this->Number->price($data['off_peak_price']); ?><br /></h3>
					<?php echo __d('buzz_bookings', '(Off Peak)'); ?>
				</span>
				<span class="listing__price">
					<?php echo $this->Html->tag('h3', null, ['class' => $class]); ?><?php echo $this->Number->price($data['peak_price']); ?><br /></h3>
					<?php echo __d('buzz_bookings', '(Peak)'); ?>
				</span>
			<?php else: ?>
				<span class="listing__price">
					<?php echo $this->Html->tag('h3', null, ['class' => $class]); ?><?php echo $this->Number->price($data['price']); ?><br /></h3>
				</span>
			<?php endif; ?>
			<span class="listing__price">
				<?php echo $this->Form->hidden('BookingItem.' . $data['id'] . '.id'); ?>
				<?php echo $this->Form->hidden('BookingItem.' . $data['id'] . '.activity_package_id', ['value' => $data['id']]); ?>
				<?php if (!empty($isPrivateHire)): ?>
					<?php echo $this->Form->button(__d('buzz_bookings', 'Select'), ['class' => 'button']); ?>
				<?php else: ?>
					<?php echo $this->Form->input('BookingItem.' . $data['id'] . '.quantity', ['label' => __d('buzz_bookings', 'Quantity')]); ?>
				<?php endif; ?>
			</span>
		</div>
	</div>
</div>
