<?php
$this->extend('/Common/view');
$this->assign('title', __d('buzz_bookings', '%s Booking Step %d', [__d('buzz_bookings', 'Private Hire'), 1]));
echo $this->Html->script(['BuzzBookings.buzz_bookings.min'], ['inline' => false]);
?>

<div class="row">
	<div class="col-xs-12 col-sm-4 col-sm-push-8">
	</div>
	<div class="col-xs-12 col-sm-8 col-sm-pull-4">
		<p><?php echo __d('buzz_bookings', 'Select the quantity of %s Packages for you, your family and friends', [$this->I18n->translate($data, 'Activity.name')]); ?></p>

		<div class="js-bookings-voucher-booking">
			<label class="left"><?php echo __d('buzz_bookings', 'Do you have a voucher?'); ?></label>
			<?php
				echo $this->Form->input(
					'vouchers',
					[
						'label' => __d('buzz_bookings', 'Yes'),
						'div' => 'input checkbox checkbox--custom js-bookings-toggle--vouchers',
						'type' => 'checkbox',
						'checked' => !empty($basket['Booking']['has_vouchers'])
					]
				);
			?>
		</div>
	</div>
</div>
<div class="toggle__content">
	<div class="row">
		<div class="col-xs-6 col-lg-3">
			<h3>Provider</h3>
		</div>

		<div class="col-xs-3 xs-gutterless--left col-lg-2">
			<h3>Voucher Number</h3>
		</div>

		<div class="col-xs-3 xs-gutterless--left col-lg-2 lg-gutterless--right">
			<h3>Expiry Date</h3>
		</div>
	</div>
	<script type="text/javascript">
		var vouchers = <?php echo json_encode($vouchers); ?>;
	</script>
	<?php
		if (!empty($basket['Booking']['has_vouchers'])):
			$numberOfVouchers = count(Hash::extract($basket, 'BookingItem.{n}.BookingItemVoucher.id'));
			$i = 0;
			foreach ($basket['BookingItem'] as $bookingItem):
				if (!empty($bookingItem['BookingItemVoucher'])):
					++$i;
					echo $this->element(
						'../Bookings/ajax_voucher_added',
						[
							'voucher' => $bookingItem['BookingItemVoucher'],
							'activityId' => $data['Activity']['id'],
							'hideButton' => $i < $numberOfVouchers || $isMultiExperience === true
						]
					);
				endif;
			endforeach;
		else:
			echo $this->element('../Bookings/ajax_voucher', ['activityId' => -1, 'isMultiExperience' => true]);
		endif;
	?>
</div>

<?php // If there is a multi-experience voucher in the basket we want to hide all the pacakges. ?>
<?php if (empty($basket['Booking']['has_vouchers'])): ?>

	<div class="content__spacer"></div>

	<div class="row js-bookings-private-hire">
		<div class="col-xs-12">
			<?php foreach ($data as $package): ?>
				<?php echo $this->Form->create(null, ['class' => 'js-multi-experience', 'id' => false]); ?>
					<?php echo $this->Form->hidden('Booking.activity_id', ['value' => $package['Activity']['id']]); ?>
					<?php echo $this->element('BuzzBookings.Forms/activity_package', ['data' => $package['ActivityPackage'], 'isPrivateHire' => true]); ?>
				<?php echo $this->Form->end(); ?>
				<div class="content__spacer"></div>
			<?php endforeach; ?>
		</div>
	</div>

<?php endif; ?>
